/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.exterminator;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIAttackRanged;
import team.cqr.cqrepoured.entity.boss.exterminator.EntityCQRExterminator;
import team.cqr.cqrepoured.entity.projectiles.ProjectileCannonBall;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class BossAIArmCannon
extends EntityAIAttackRanged<EntityCQRExterminator> {
    private boolean isCurrentSequenceFast = false;
    private boolean isSequenceRunning = false;
    private int remainingShotsInSequence = -1;
    private static final int SHOT_COUNT_FAST = 10;
    private static final int SHOT_COUNT_NORMAL = 1;
    private static final double MIN_DISTANCE_SQ = 9.0;
    private int cooldown = 100;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 400;

    @Override
    public boolean func_75250_a() {
        if (super.func_75250_a()) {
            if (((EntityCQRExterminator)this.entity).isStunned()) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.isFarAwayEnough()) {
                if (((EntityCQRExterminator)this.entity).hasAttackTarget()) {
                    this.cooldown = (int)((float)this.cooldown - ((EntityCQRExterminator)this.entity).func_70032_d((Entity)((EntityCQRExterminator)this.entity).func_70638_az()));
                }
                return this.cooldown <= 0;
            }
        }
        return false;
    }

    @Override
    protected boolean canStrafe() {
        return super.canStrafe() && !this.isSequenceRunning && !((EntityCQRExterminator)this.entity).isStunned();
    }

    @Override
    public boolean func_75253_b() {
        if (((EntityCQRExterminator)this.entity).isStunned()) {
            return false;
        }
        return super.func_75253_b() && (this.isFarAwayEnough() || this.isSequenceRunning);
    }

    private boolean isFarAwayEnough() {
        return ((EntityCQRExterminator)this.entity).func_70068_e((Entity)((EntityCQRExterminator)this.entity).func_70638_az()) >= 9.0;
    }

    public BossAIArmCannon(EntityCQRExterminator entity) {
        super(entity);
    }

    @Override
    protected void checkAndPerformAttack(EntityLivingBase attackTarget) {
        if (((EntityCQRExterminator)this.entity).field_70173_aa > this.prevTimeAttacked + this.getAttackCooldown()) {
            if (((EntityCQRExterminator)this.entity).isCannonRaised()) {
                if (((EntityCQRExterminator)this.entity).isCannonArmReadyToShoot()) {
                    if (!this.isSequenceRunning) {
                        this.isSequenceRunning = true;
                        this.isCurrentSequenceFast = ((EntityCQRExterminator)this.entity).func_70681_au().nextBoolean();
                        this.remainingShotsInSequence = this.isCurrentSequenceFast ? 10 : 1;
                    }
                    ((EntityCQRExterminator)this.entity).startShootingAnimation(this.isCurrentSequenceFast);
                    ((EntityCQRExterminator)this.entity).func_70625_a((Entity)attackTarget, 180.0f, 180.0f);
                    ProjectileCannonBall cannonBall = new ProjectileCannonBall(this.world, (EntityLivingBase)this.entity, this.isCurrentSequenceFast);
                    Vec3d armPos = ((EntityCQRExterminator)this.entity).getCannonFiringLocation();
                    this.spawnParticles(armPos);
                    cannonBall.func_70107_b(armPos.field_72450_a, armPos.field_72448_b, armPos.field_72449_c);
                    double vx = attackTarget.field_70165_t - ((EntityCQRExterminator)this.entity).field_70165_t + ((EntityCQRExterminator)this.entity).field_70159_w;
                    double vy = attackTarget.field_70163_u + (double)attackTarget.field_70131_O * 0.5 - armPos.field_72448_b + ((EntityCQRExterminator)this.entity).field_70181_x;
                    double vz = attackTarget.field_70161_v - ((EntityCQRExterminator)this.entity).field_70161_v + ((EntityCQRExterminator)this.entity).field_70179_y;
                    float inaccuracy = this.getInaccuracy();
                    if (this.isCurrentSequenceFast) {
                        inaccuracy *= 2.0f;
                    }
                    cannonBall.func_70186_c(vx, vy, vz, 1.2f, inaccuracy);
                    ((EntityCQRExterminator)this.entity).func_184185_a(CQRSounds.EXTERMINATOR_CANNON_SHOOT, 5.0f, 0.75f + ((EntityCQRExterminator)this.entity).func_70681_au().nextFloat() * 0.5f);
                    this.world.func_72838_d((Entity)cannonBall);
                    --this.remainingShotsInSequence;
                    if (this.remainingShotsInSequence <= 0) {
                        this.prevTimeAttacked = ((EntityCQRExterminator)this.entity).field_70173_aa;
                        this.func_75251_c();
                    }
                }
            } else {
                ((EntityCQRExterminator)this.entity).switchCannonArmState(true);
            }
        }
    }

    @Override
    protected float getStrafingSpeed() {
        if (this.isCurrentSequenceFast) {
            return 1.25f * super.getStrafingSpeed();
        }
        return super.getStrafingSpeed();
    }

    private void spawnParticles(Vec3d armPos) {
        if (this.world instanceof WorldServer) {
            ((WorldServer)this.world).func_180505_a(EnumParticleTypes.SMOKE_LARGE, true, armPos.field_72450_a, armPos.field_72448_b, armPos.field_72449_c, 10, 0.0, 0.0, 0.0, 0.05, new int[0]);
            ((WorldServer)this.world).func_180505_a(EnumParticleTypes.CLOUD, true, armPos.field_72450_a, armPos.field_72448_b, armPos.field_72449_c, 5, 0.0, 0.0, 0.0, 0.05, new int[0]);
            ((WorldServer)this.world).func_180505_a(EnumParticleTypes.FLAME, true, armPos.field_72450_a, armPos.field_72448_b, armPos.field_72449_c, 5, 0.0, 0.0, 0.0, 0.05, new int[0]);
        }
    }

    public boolean func_75252_g() {
        return ((EntityCQRExterminator)this.entity).func_70681_au().nextBoolean();
    }

    @Override
    protected int getAttackCooldown() {
        switch (this.world.func_175659_aa()) {
            case HARD: {
                return 20;
            }
            case NORMAL: {
                return 30;
            }
        }
        return 40;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        ((EntityCQRExterminator)this.entity).setCannonArmAutoTimeoutForLowering(40);
        this.isSequenceRunning = false;
        this.cooldown = DungeonGenUtils.randomBetween(200, 400, ((EntityCQRExterminator)this.entity).func_70681_au());
    }

    @Override
    protected boolean isRangedWeapon(Item item) {
        return true;
    }
}

