/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public class EntityAIOpenCloseDoor
extends AbstractCQREntityAI<AbstractEntityCQR> {
    private final BlockPos.MutableBlockPos doorPos = new BlockPos.MutableBlockPos();
    private BlockDoor doorBlock;
    private EnumFacing doorEnterFacing;
    private boolean hasStoppedDoorInteraction;
    private double entityPositionX;
    private double entityPositionZ;
    private int tick;

    public EntityAIOpenCloseDoor(AbstractEntityCQR entity) {
        super(entity);
    }

    public boolean func_75250_a() {
        if (!this.entity.canOpenDoors()) {
            return false;
        }
        if (!this.entity.func_70781_l()) {
            return false;
        }
        this.doorPos.func_189532_c(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        IBlockState state = this.world.func_180495_p((BlockPos)this.doorPos);
        if (state.func_177230_c() instanceof BlockDoor) {
            this.doorBlock = (BlockDoor)state.func_177230_c();
            this.doorEnterFacing = this.entity.func_174811_aO().func_176734_d();
            return EntityAIOpenCloseDoor.canMoveThroughDoor((IBlockAccess)this.world, (BlockPos)this.doorPos, this.doorEnterFacing, true);
        }
        Path path = this.entity.func_70661_as().func_75505_d();
        int end = Math.min(path.func_75873_e() + 2, path.func_75874_d());
        for (int i = path.func_75873_e(); i < end; ++i) {
            PathPoint pathPoint = path.func_75877_a(i);
            this.doorPos.func_181079_c(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
            if (this.entity.func_70092_e((double)this.doorPos.func_177958_n() + 0.5, this.doorPos.func_177956_o(), (double)this.doorPos.func_177952_p() + 0.5) >= 2.25 || !((state = this.world.func_180495_p((BlockPos)this.doorPos)).func_177230_c() instanceof BlockDoor)) continue;
            this.doorBlock = (BlockDoor)state.func_177230_c();
            if (i > 0) {
                PathPoint pathPoint1 = path.func_75877_a(i - 1);
                this.doorEnterFacing = EnumFacing.func_176737_a((float)(pathPoint1.field_75839_a - pathPoint.field_75839_a), (float)(pathPoint1.field_75837_b - pathPoint.field_75837_b), (float)(pathPoint1.field_75838_c - pathPoint.field_75838_c));
            } else {
                this.doorEnterFacing = this.entity.func_174811_aO().func_176734_d();
            }
            return EntityAIOpenCloseDoor.canMoveThroughDoor((IBlockAccess)this.world, (BlockPos)this.doorPos, this.doorEnterFacing, true);
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.hasStoppedDoorInteraction;
    }

    public void func_75249_e() {
        this.entityPositionX = (double)this.doorPos.func_177958_n() + 0.5 - this.entity.field_70165_t;
        this.entityPositionZ = (double)this.doorPos.func_177952_p() + 0.5 - this.entity.field_70161_v;
    }

    public void func_75251_c() {
        this.hasStoppedDoorInteraction = false;
        this.tick = 0;
        this.closeDoor();
    }

    public void func_75246_d() {
        if (this.tick++ > 60) {
            this.hasStoppedDoorInteraction = true;
        }
        this.openDoor();
        double dx = (double)this.doorPos.func_177958_n() + 0.5 - this.entity.field_70165_t;
        double dz = (double)this.doorPos.func_177952_p() + 0.5 - this.entity.field_70161_v;
        double d = this.entityPositionX * dx + this.entityPositionZ * dz;
        if (d < 0.0 && (MathHelper.func_76128_c((double)this.entity.field_70165_t) != this.doorPos.func_177958_n() || MathHelper.func_76128_c((double)this.entity.field_70163_u) != this.doorPos.func_177956_o() || MathHelper.func_76128_c((double)this.entity.field_70161_v) != this.doorPos.func_177952_p())) {
            this.hasStoppedDoorInteraction = true;
        }
    }

    private boolean openDoor() {
        EnumFacing.Axis blockedAxis;
        IBlockState state = this.world.func_180495_p((BlockPos)this.doorPos);
        if (!(state.func_177230_c() instanceof BlockDoor)) {
            return false;
        }
        state = state.func_185899_b((IBlockAccess)this.world, (BlockPos)this.doorPos);
        boolean doorOpen = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        EnumFacing doorFacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        EnumFacing.Axis axis = blockedAxis = doorOpen ? doorFacing.func_176746_e().func_176740_k() : doorFacing.func_176740_k();
        if (this.doorEnterFacing.func_176740_k() != blockedAxis) {
            return false;
        }
        if (state.func_185904_a() == Material.field_151575_d) {
            this.doorBlock.func_176512_a(this.world, (BlockPos)this.doorPos, !doorOpen);
            return true;
        }
        if (!doorOpen) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            Object pos = state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? this.doorPos.func_177977_b() : this.doorPos;
            if (this.isPressurePlate((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(this.doorEnterFacing))) {
                return true;
            }
            if (this.activateButtonOrLeverWithOrientation((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(this.doorEnterFacing).func_189536_c(this.doorEnterFacing.func_176746_e()).func_189536_c(EnumFacing.UP), this.doorEnterFacing)) {
                return true;
            }
            if (this.activateButtonOrLeverWithOrientation((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(this.doorEnterFacing).func_189536_c(this.doorEnterFacing.func_176735_f()).func_189536_c(EnumFacing.UP), this.doorEnterFacing)) {
                return true;
            }
            if (this.activateButtonOrLeverWithOrientation((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(this.doorEnterFacing).func_189536_c(this.doorEnterFacing.func_176746_e()), this.doorEnterFacing)) {
                return true;
            }
            if (this.activateButtonOrLeverWithOrientation((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(this.doorEnterFacing).func_189536_c(this.doorEnterFacing.func_176735_f()), this.doorEnterFacing)) {
                return true;
            }
        }
        return false;
    }

    private boolean isPressurePlate(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block instanceof BlockPressurePlate && (material == Material.field_151575_d || material == Material.field_151576_e);
    }

    private boolean activateButtonOrLeverWithOrientation(BlockPos pos, EnumFacing facing) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockButton && state.func_177229_b((IProperty)BlockDirectional.field_176387_N) == facing) {
            block.func_180639_a(this.world, pos, state, null, EnumHand.MAIN_HAND, facing, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            return true;
        }
        if (block instanceof BlockLever && ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() == facing) {
            block.func_180639_a(this.world, pos, state, null, EnumHand.MAIN_HAND, facing, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            return true;
        }
        return false;
    }

    private boolean closeDoor() {
        IBlockState state = this.world.func_180495_p((BlockPos)this.doorPos);
        if (!(state.func_177230_c() instanceof BlockDoor)) {
            return false;
        }
        if (state.func_185904_a() != Material.field_151575_d) {
            return false;
        }
        boolean shouldCloseDoor = true;
        double x = this.entity.field_70165_t;
        double y = this.entity.field_70163_u;
        double z = this.entity.field_70161_v;
        double r = 4.0;
        AxisAlignedBB aabb = new AxisAlignedBB(x - r, y - r * 0.5, z - r, x + r, y + r * 0.5, z + r);
        List allies = this.world.func_175647_a(AbstractEntityCQR.class, aabb, e -> TargetUtil.isAllyCheckingLeaders((EntityLivingBase)this.entity, (EntityLivingBase)e));
        block0: for (AbstractEntityCQR ally : allies) {
            if (ally == this.entity || !ally.func_70781_l() || ally.func_70068_e((Entity)this.entity) >= r * r) continue;
            if (MathHelper.func_76128_c((double)ally.field_70165_t) == this.doorPos.func_177958_n() && MathHelper.func_76128_c((double)ally.field_70163_u) == this.doorPos.func_177956_o() && MathHelper.func_76128_c((double)ally.field_70161_v) == this.doorPos.func_177952_p()) {
                shouldCloseDoor = false;
                break;
            }
            Path path = ally.func_70661_as().func_75505_d();
            int end = Math.min(path.func_75873_e() + 2, path.func_75874_d());
            for (int i = path.func_75873_e(); i < end; ++i) {
                PathPoint pathPoint = path.func_75877_a(i);
                if (pathPoint.field_75839_a != this.doorPos.func_177958_n() || pathPoint.field_75837_b != this.doorPos.func_177956_o() || pathPoint.field_75838_c != this.doorPos.func_177952_p()) continue;
                shouldCloseDoor = false;
                continue block0;
            }
        }
        if (shouldCloseDoor) {
            this.doorBlock.func_176512_a(this.world, (BlockPos)this.doorPos, false);
            return true;
        }
        return false;
    }

    public static boolean canMoveThroughDoor(IBlockAccess world, BlockPos pos, EnumFacing enterFacing, boolean canOpenCloseDoors) {
        EnumFacing.Axis blockedAxis;
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockDoor)) {
            return false;
        }
        state = state.func_185899_b(world, pos);
        boolean doorOpen = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        EnumFacing doorFacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        EnumFacing.Axis axis = blockedAxis = doorOpen ? doorFacing.func_176746_e().func_176740_k() : doorFacing.func_176740_k();
        if (enterFacing.func_176740_k() != blockedAxis) {
            return true;
        }
        if (!canOpenCloseDoors) {
            return false;
        }
        if (state.func_185904_a() == Material.field_151575_d) {
            return true;
        }
        if (doorOpen) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            pos = pos.func_177977_b();
        }
        if (EntityAIOpenCloseDoor.isPressurePlate(world, (BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(enterFacing))) {
            return true;
        }
        if (EntityAIOpenCloseDoor.isButtonOrLeverWithOrientation(world, (BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(enterFacing).func_189536_c(enterFacing.func_176746_e()).func_189536_c(EnumFacing.UP), enterFacing)) {
            return true;
        }
        if (EntityAIOpenCloseDoor.isButtonOrLeverWithOrientation(world, (BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(enterFacing).func_189536_c(enterFacing.func_176735_f()).func_189536_c(EnumFacing.UP), enterFacing)) {
            return true;
        }
        if (EntityAIOpenCloseDoor.isButtonOrLeverWithOrientation(world, (BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(enterFacing).func_189536_c(enterFacing.func_176746_e()), enterFacing)) {
            return true;
        }
        return EntityAIOpenCloseDoor.isButtonOrLeverWithOrientation(world, (BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_189536_c(enterFacing).func_189536_c(enterFacing.func_176735_f()), enterFacing);
    }

    private static boolean isPressurePlate(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block instanceof BlockPressurePlate && (material == Material.field_151575_d || material == Material.field_151576_e);
    }

    private static boolean isButtonOrLeverWithOrientation(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockButton) {
            return state.func_177229_b((IProperty)BlockDirectional.field_176387_N) == facing;
        }
        if (block instanceof BlockLever) {
            return ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() == facing;
        }
        return false;
    }
}

