/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.trade.Trade;
import team.cqr.cqrepoured.entity.trade.TraderOffer;

public interface ITradeRestockOverTime {
    public long getLastTimedRestockTime();

    public void setLastTimedRestockTime(long var1);

    public TraderOffer getTrades();

    public boolean hasTrades();

    default public void updateTradeRestockTimer() {
        if (CQRConfig.mobs.enableTradeRestockOverTime && this instanceof Entity) {
            if (!this.hasTrades()) {
                return;
            }
            long ticksExisted = ((Entity)this).field_70170_p.func_82737_E();
            long lastTimed = this.getLastTimedRestockTime();
            if (lastTimed <= 0L) {
                this.setLastTimedRestockTime(ticksExisted);
                return;
            }
            long delta = ticksExisted - lastTimed;
            int restocks = (int)Math.floorDiv(delta, (long)CQRConfig.mobs.tradeRestockTime);
            restocks = Math.min(restocks, CQRConfig.mobs.maxAutoRestocksOverTime);
            if (delta > 0L && restocks > 0) {
                if (this.getTrades() != null) {
                    TraderOffer offer = this.getTrades();
                    List trades = offer.getTrades().stream().filter(Trade::canRestock).collect(Collectors.toList());
                    for (int i = 0; !trades.isEmpty() && i < restocks; ++i) {
                        int index = ((Entity)this).field_70170_p.field_73012_v.nextInt(trades.size());
                        Trade trade = (Trade)trades.get(index);
                        trade.incStock();
                        if (trade.canRestock()) continue;
                        trades.remove(index);
                    }
                }
                this.setLastTimedRestockTime(ticksExisted);
            }
        }
    }
}

