/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import team.cqr.cqrepoured.client.render.shader.ResourceSupplier;
import team.cqr.cqrepoured.client.render.shader.ShaderProgram;
import team.cqr.cqrepoured.client.render.texture.CubemapTexture;

public class SphereRenderer {
    private static final List<Quad> CUBE;
    private static final List<Triangle> ICOSAHEDRON;
    private static final List<Triangle> OCTAHEDRON;
    private static final FloatBuffer BUFFER;
    private static ShaderProgram shader;
    private static int uniformColor;
    private static int uniformTexture;
    private static int prevProgram;

    public static void init() {
        SphereRenderer.delete();
        shader = new ShaderProgram.Builder().addShader(35633, new ResourceSupplier(new ResourceLocation("cqrepoured", "shaders/sphere/vertex.glsl"))).addShader(35632, new ResourceSupplier(new ResourceLocation("cqrepoured", "shaders/sphere/fragment.glsl"))).build();
        GL20.glUseProgram((int)shader.getShaderProgram());
        uniformColor = GL20.glGetUniformLocation((int)shader.getShaderProgram(), (CharSequence)"color");
        uniformTexture = GL20.glGetUniformLocation((int)shader.getShaderProgram(), (CharSequence)"useTexture");
        GL20.glUseProgram((int)0);
    }

    private static void delete() {
        if (shader != null) {
            shader.delete();
            shader = null;
        }
    }

    public static Stream<Quad> getCubeSphere() {
        return CUBE.stream();
    }

    public static Stream<Triangle> getIcoSphere() {
        return ICOSAHEDRON.stream();
    }

    public static Stream<Triangle> getOctaSphere() {
        return OCTAHEDRON.stream();
    }

    public static <T extends Shape> Function<T, Stream<T>> splitter(int splitCount, boolean normalize) {
        return shape -> {
            Stream<Shape> stream = Stream.of(shape);
            for (int i = 0; i < splitCount; ++i) {
                stream = stream.flatMap(shape1 -> shape1.split(normalize));
            }
            return stream;
        };
    }

    public static <T extends Shape> Consumer<T> defaultBufferer(BufferBuilder buffer) {
        return shape -> shape.vertices().forEach(vertex -> buffer.func_181662_b(vertex.x, vertex.y, vertex.z).func_181675_d());
    }

    public static <T extends Shape> Consumer<T> lineBufferer(BufferBuilder buffer, double width, int lod) {
        if (lod < 0) {
            throw new IllegalArgumentException();
        }
        return shape -> {
            int lod1 = (int)Math.pow(4.0, lod);
            Vertex[] outer = (Vertex[])shape.vertices().toArray(Vertex[]::new);
            Vertex[] outerDir = SphereRenderer.fill(new Vertex[outer.length], i -> SphereRenderer.next(outer, i).subtract(outer[i]));
            Vertex[] inner = SphereRenderer.fill(new Vertex[outer.length], i -> {
                Vertex v = outerDir[i].normalize().subtract(SphereRenderer.prev(outerDir, i).normalize()).normalize();
                double d = outerDir[i].normalize().dot(v);
                return outer[i].add(v.scale(width / Math.sqrt(1.0 - d * d))).normalize();
            });
            Vertex[] innerDir = SphereRenderer.fill(new Vertex[outer.length], i -> SphereRenderer.next(inner, i).subtract(inner[i]));
            Vertex[] outer1 = SphereRenderer.fill(new Vertex[outer.length * lod1], i -> {
                if (i % lod1 == 0) {
                    return outer[i / lod1];
                }
                return outer[i / lod1].add(outerDir[i / lod1].scale((double)(i % lod1) / (double)lod1)).normalize();
            });
            Vertex[] inner1 = SphereRenderer.fill(new Vertex[outer.length * lod1], i -> {
                if (i % lod1 == 0) {
                    return inner[i / lod1];
                }
                return inner[i / lod1].add(innerDir[i / lod1].scale((double)(i % lod1) / (double)lod1)).normalize();
            });
            for (int i2 = 0; i2 < outer.length; ++i2) {
                for (int j = 0; j < lod1; ++j) {
                    Vertex v0 = inner1[i2 * lod1 + j];
                    Vertex v1 = outer1[i2 * lod1 + j];
                    Vertex v2 = SphereRenderer.next(outer1, i2 * lod1 + j);
                    Vertex v3 = SphereRenderer.next(inner1, i2 * lod1 + j);
                    buffer.func_181662_b(v0.x, v0.y, v0.z).func_181675_d();
                    buffer.func_181662_b(v1.x, v1.y, v1.z).func_181675_d();
                    buffer.func_181662_b(v2.x, v2.y, v2.z).func_181675_d();
                    buffer.func_181662_b(v3.x, v3.y, v3.z).func_181675_d();
                }
            }
        };
    }

    private static <T> T[] fill(T[] arr, IntFunction<T> func) {
        IntStream.range(0, arr.length).forEach(i -> {
            arr[i] = func.apply(i);
        });
        return arr;
    }

    private static <T> T next(T[] arr, int index) {
        return arr[(index + 1) % arr.length];
    }

    private static <T> T prev(T[] arr, int index) {
        return arr[(index + arr.length - 1) % arr.length];
    }

    public static void renderSphere(VertexBuffer buffer, int mode, @Nullable ResourceLocation textureLocation, boolean drawFront, boolean drawBack) {
        if (!drawFront && !drawBack) {
            return;
        }
        SphereRenderer.preDraw(textureLocation);
        buffer.func_177359_a();
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        if (drawBack) {
            GL11.glCullFace((int)1028);
            buffer.func_177358_a(mode);
            GL11.glCullFace((int)1029);
        }
        if (drawFront) {
            buffer.func_177358_a(mode);
        }
        GL20.glDisableVertexAttribArray((int)0);
        buffer.func_177361_b();
        SphereRenderer.postDraw();
    }

    public static void renderSphere(BufferBuilder buffer, int mode, @Nullable ResourceLocation textureLocation, boolean drawFront, boolean drawBack) {
        if (!drawFront && !drawBack) {
            return;
        }
        SphereRenderer.preDraw(textureLocation);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (ByteBuffer)buffer.func_178966_f());
        GL20.glEnableVertexAttribArray((int)0);
        if (drawBack) {
            GL11.glCullFace((int)1028);
            GL11.glDrawArrays((int)mode, (int)0, (int)buffer.func_178989_h());
            GL11.glCullFace((int)1029);
        }
        if (drawFront) {
            GL11.glDrawArrays((int)mode, (int)0, (int)buffer.func_178989_h());
        }
        GL20.glDisableVertexAttribArray((int)0);
        SphereRenderer.postDraw();
    }

    private static void preDraw(@Nullable ResourceLocation textureLocation) {
        prevProgram = GL11.glGetInteger((int)35725);
        GL20.glUseProgram((int)shader.getShaderProgram());
        GL11.glGetFloat((int)2816, (FloatBuffer)BUFFER);
        GL20.glUniform4f((int)uniformColor, (float)BUFFER.get(0), (float)BUFFER.get(1), (float)BUFFER.get(2), (float)BUFFER.get(3));
        if (textureLocation != null) {
            GL20.glUniform1i((int)uniformTexture, (int)1);
            Minecraft mc = Minecraft.func_71410_x();
            TextureManager textureManager = mc.func_110434_K();
            ITextureObject texture = textureManager.func_110581_b(CubemapTexture.get(textureLocation));
            GL11.glBindTexture((int)34067, (int)texture.func_110552_b());
        } else {
            GL20.glUniform1i((int)uniformTexture, (int)0);
        }
    }

    private static void postDraw() {
        GL20.glUseProgram((int)prevProgram);
    }

    static {
        ArrayList<Shape> list = new ArrayList<Shape>();
        double d = Math.sqrt(0.3333333333333333);
        Vertex v0 = new Vertex(-d, -d, -d);
        Vertex v1 = new Vertex(-d, -d, d);
        Vertex v2 = new Vertex(-d, d, -d);
        Vertex v3 = new Vertex(-d, d, d);
        Vertex v4 = new Vertex(d, -d, -d);
        Vertex v5 = new Vertex(d, -d, d);
        Vertex v6 = new Vertex(d, d, -d);
        Vertex v7 = new Vertex(d, d, d);
        list.add(new Quad(v3, v7, v6, v2));
        list.add(new Quad(v0, v4, v5, v1));
        list.add(new Quad(v0, v1, v3, v2));
        list.add(new Quad(v1, v5, v7, v3));
        list.add(new Quad(v5, v4, v6, v7));
        list.add(new Quad(v4, v0, v2, v6));
        list.trimToSize();
        CUBE = Collections.unmodifiableList(list);
        list = new ArrayList();
        double goldenRatio = (1.0 + Math.sqrt(5.0)) * 0.5;
        double d1 = Math.sqrt(1.0 / (goldenRatio * goldenRatio + 1.0));
        double d2 = goldenRatio * d1;
        Vertex v02 = new Vertex(-d1, d2, 0.0);
        Vertex v12 = new Vertex(d1, d2, 0.0);
        Vertex v22 = new Vertex(-d1, -d2, 0.0);
        Vertex v32 = new Vertex(d1, -d2, 0.0);
        Vertex v42 = new Vertex(0.0, -d1, d2);
        Vertex v52 = new Vertex(0.0, d1, d2);
        Vertex v62 = new Vertex(0.0, -d1, -d2);
        Vertex v72 = new Vertex(0.0, d1, -d2);
        Vertex v8 = new Vertex(d2, 0.0, -d1);
        Vertex v9 = new Vertex(d2, 0.0, d1);
        Vertex v10 = new Vertex(-d2, 0.0, -d1);
        Vertex v11 = new Vertex(-d2, 0.0, d1);
        list.add(new Triangle(v02, v11, v52));
        list.add(new Triangle(v02, v52, v12));
        list.add(new Triangle(v02, v12, v72));
        list.add(new Triangle(v02, v72, v10));
        list.add(new Triangle(v02, v10, v11));
        list.add(new Triangle(v12, v52, v9));
        list.add(new Triangle(v52, v11, v42));
        list.add(new Triangle(v11, v10, v22));
        list.add(new Triangle(v10, v72, v62));
        list.add(new Triangle(v72, v12, v8));
        list.add(new Triangle(v32, v9, v42));
        list.add(new Triangle(v32, v42, v22));
        list.add(new Triangle(v32, v22, v62));
        list.add(new Triangle(v32, v62, v8));
        list.add(new Triangle(v32, v8, v9));
        list.add(new Triangle(v42, v9, v52));
        list.add(new Triangle(v22, v42, v11));
        list.add(new Triangle(v62, v22, v10));
        list.add(new Triangle(v8, v62, v72));
        list.add(new Triangle(v9, v8, v12));
        list.trimToSize();
        ICOSAHEDRON = Collections.unmodifiableList(list);
        list = new ArrayList();
        Vertex v03 = new Vertex(-1.0, 0.0, 0.0);
        Vertex v13 = new Vertex(1.0, 0.0, 0.0);
        Vertex v23 = new Vertex(0.0, -1.0, 0.0);
        Vertex v33 = new Vertex(0.0, 1.0, 0.0);
        Vertex v43 = new Vertex(0.0, 0.0, -1.0);
        Vertex v53 = new Vertex(0.0, 0.0, 1.0);
        list.add(new Triangle(v53, v03, v23));
        list.add(new Triangle(v03, v43, v23));
        list.add(new Triangle(v43, v13, v23));
        list.add(new Triangle(v13, v53, v23));
        list.add(new Triangle(v53, v13, v33));
        list.add(new Triangle(v13, v43, v33));
        list.add(new Triangle(v43, v03, v33));
        list.add(new Triangle(v03, v53, v33));
        list.trimToSize();
        OCTAHEDRON = Collections.unmodifiableList(list);
        BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public static class Quad
    implements Shape {
        public final Vertex v0;
        public final Vertex v1;
        public final Vertex v2;
        public final Vertex v3;

        public Quad(Vertex v0, Vertex v1, Vertex v2, Vertex v3) {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        public Stream<Quad> split(boolean normalize) {
            Vertex v01 = this.v0.add(this.v1);
            Vertex v12 = this.v1.add(this.v2);
            Vertex v23 = this.v2.add(this.v3);
            Vertex v30 = this.v3.add(this.v0);
            Vertex v02 = this.v0.add(this.v2);
            if (normalize) {
                v01 = v01.normalize();
                v12 = v12.normalize();
                v23 = v23.normalize();
                v30 = v30.normalize();
                v02 = v02.normalize();
            } else {
                v01 = v01.scale(0.5);
                v12 = v12.scale(0.5);
                v23 = v23.scale(0.5);
                v30 = v30.scale(0.5);
                v02 = v02.scale(0.5);
            }
            return Stream.of(new Quad(v30, this.v0, v01, v02), new Quad(v01, this.v1, v12, v02), new Quad(v12, this.v2, v23, v02), new Quad(v23, this.v3, v30, v02));
        }

        @Override
        public Stream<Vertex> vertices() {
            return Stream.of(this.v0, this.v1, this.v2, this.v3);
        }

        public Stream<Triangle> triangles() {
            return Stream.of(new Triangle(this.v0, this.v1, this.v2), new Triangle(this.v2, this.v3, this.v0));
        }
    }

    public static class Triangle
    implements Shape {
        public final Vertex v0;
        public final Vertex v1;
        public final Vertex v2;

        public Triangle(Vertex v0, Vertex v1, Vertex v2) {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
        }

        public Stream<Triangle> split(boolean normalize) {
            Vertex v01 = this.v0.add(this.v1);
            Vertex v12 = this.v1.add(this.v2);
            Vertex v20 = this.v2.add(this.v0);
            if (normalize) {
                v01 = v01.normalize();
                v12 = v12.normalize();
                v20 = v20.normalize();
            } else {
                v01 = v01.scale(0.5);
                v12 = v12.scale(0.5);
                v20 = v20.scale(0.5);
            }
            return Stream.of(new Triangle(v01, this.v1, v12), new Triangle(v12, this.v2, v20), new Triangle(v20, this.v0, v01), new Triangle(v20, v01, v12));
        }

        @Override
        public Stream<Vertex> vertices() {
            return Stream.of(this.v0, this.v1, this.v2);
        }
    }

    public static interface Shape {
        public Stream<? extends Shape> split(boolean var1);

        public Stream<Vertex> vertices();
    }

    public static class Vertex {
        public final double x;
        public final double y;
        public final double z;

        public Vertex(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vertex normalize() {
            double d = 1.0 / this.length();
            return new Vertex(this.x * d, this.y * d, this.z * d);
        }

        public Vertex add(Vertex vertex) {
            return new Vertex(this.x + vertex.x, this.y + vertex.y, this.z + vertex.z);
        }

        public Vertex subtract(Vertex vertex) {
            return new Vertex(this.x - vertex.x, this.y - vertex.y, this.z - vertex.z);
        }

        public Vertex scale(double d) {
            return new Vertex(this.x * d, this.y * d, this.z * d);
        }

        public double dot(Vertex vertex) {
            return this.x * vertex.x + this.y * vertex.y + this.z * vertex.z;
        }

        public double length() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vertex cross(Vertex vertex) {
            return new Vertex(this.y * vertex.z - this.z * vertex.y, this.z * vertex.x - this.x * vertex.z, this.x * vertex.y - this.y * vertex.x);
        }

        public Vertex negate() {
            return new Vertex(-this.x, -this.y, -this.z);
        }

        public Vertex rotate(Vertex axis, double radian) {
            axis = axis.normalize();
            double d = Math.sin(radian * 0.5);
            double i = d * axis.x;
            double j = d * axis.y;
            double k = d * axis.z;
            double r = Math.cos(radian * 0.5);
            double i2 = 2.0 * i * i;
            double j2 = 2.0 * j * j;
            double k2 = 2.0 * k * k;
            double ij = 2.0 * i * j;
            double jk = 2.0 * j * k;
            double ik = 2.0 * i * k;
            double ir = 2.0 * i * r;
            double jr = 2.0 * j * r;
            double kr = 2.0 * k * r;
            double d00 = 1.0 - (j2 + k2);
            double d01 = ij - kr;
            double d02 = ik + jr;
            double d10 = ij + kr;
            double d11 = 1.0 - (i2 + k2);
            double d12 = jk - ir;
            double d20 = ik - jr;
            double d21 = jk + ir;
            double d22 = 1.0 - (i2 + j2);
            return new Vertex(this.x * d00 + this.y * d01 + this.z * d02, this.x * d10 + this.y * d11 + this.z * d12, this.x * d20 + this.y * d21 + this.z * d22);
        }
    }
}

