/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL14;
import team.cqr.cqrepoured.client.util.EmissiveUtil;
import team.cqr.cqrepoured.util.VectorUtil;

public class ElectricFieldRenderUtil {
    private static final Random RANDOM = new Random(){
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private long seed = 0L;

        @Override
        public void setSeed(long seed) {
            this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        }

        @Override
        protected int next(int bits) {
            this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return (int)(this.seed >>> 48 - bits);
        }
    };
    private static final Tessellator TESSELATOR = Tessellator.func_178181_a();
    private static final BufferBuilder VERTEX_BUFFER = TESSELATOR.func_178180_c();
    private static final IntBuffer FIRST_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    private static final IntBuffer COUNT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    private static int vertexCount;

    private static void startLineStripBatch(VertexFormat format) {
        VERTEX_BUFFER.func_181668_a(3, format);
    }

    private static void addVertex(double x, double y, double z, boolean endLineStrip) {
        VERTEX_BUFFER.func_181662_b(x, y, z).func_181675_d();
        ++vertexCount;
        if (endLineStrip) {
            FIRST_BUFFER.put(VERTEX_BUFFER.func_178989_h() - vertexCount);
            COUNT_BUFFER.put(vertexCount);
            vertexCount = 0;
        }
    }

    private static void endLineStripBatch() {
        if (vertexCount > 0) {
            throw new IllegalStateException("Last line strip not finished!");
        }
        VERTEX_BUFFER.func_178977_d();
        FIRST_BUFFER.flip();
        COUNT_BUFFER.flip();
        VertexFormat format = VERTEX_BUFFER.func_178973_g();
        IntStream.range(0, format.func_177345_h()).forEach(i -> format.func_177348_c(i).func_177375_c().preDraw(format, i, format.func_177338_f(), VERTEX_BUFFER.func_178966_f()));
        GL14.glMultiDrawArrays((int)3, (IntBuffer)FIRST_BUFFER, (IntBuffer)COUNT_BUFFER);
        IntStream.range(0, format.func_177345_h()).forEach(i -> format.func_177348_c(i).func_177375_c().preDraw(format, i, format.func_177338_f(), VERTEX_BUFFER.func_178966_f()));
        VERTEX_BUFFER.func_178965_a();
        FIRST_BUFFER.clear();
        COUNT_BUFFER.clear();
    }

    public static void renderElectricField(double fieldRadius, double fieldHeight, double x, double y, double z, int bolts, long seed) {
        RANDOM.setSeed(seed);
        EmissiveUtil.preEmissiveTextureRendering();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179131_c((float)0.5f, (float)0.64f, (float)1.0f, (float)0.6f);
        ElectricFieldRenderUtil.startLineStripBatch(DefaultVertexFormats.field_181705_e);
        for (int boltCount = 0; boltCount < bolts; ++boltCount) {
            int steps = RANDOM.nextInt(26) + 5;
            for (int i = 0; i <= steps; ++i) {
                double vX = (double)(RANDOM.nextFloat() * 2.0f - 1.0f) * fieldRadius;
                double vZ = (double)(RANDOM.nextFloat() * 2.0f - 1.0f) * fieldRadius;
                double vY = (double)(RANDOM.nextFloat() * 2.0f - 1.0f) * fieldHeight;
                ElectricFieldRenderUtil.addVertex(x + vX, y + vY, z + vZ, i == steps);
            }
        }
        ElectricFieldRenderUtil.endLineStripBatch();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        EmissiveUtil.postEmissiveTextureRendering();
    }

    public static void renderElectricLineBetween(Vec3d startOffset, Vec3d endOffset, double maxOffset, double posX, double posY, double posZ, int boltCount, long seed) {
        startOffset = startOffset.func_72441_c(posX, posY, posZ);
        endOffset = endOffset.func_72441_c(posX, posY, posZ);
        RANDOM.setSeed(seed);
        EmissiveUtil.preEmissiveTextureRendering();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179131_c((float)0.5f, (float)0.64f, (float)1.0f, (float)0.6f);
        ElectricFieldRenderUtil.startLineStripBatch(DefaultVertexFormats.field_181705_e);
        Vec3d direction = endOffset.func_178788_d(startOffset);
        double distance = direction.func_72433_c();
        direction = direction.func_186678_a(1.0 / distance);
        Vec3d directionOffset = direction.field_72450_a < 0.5 ? direction.func_72431_c(new Vec3d(1.0, 0.0, 0.0)).func_72432_b() : direction.func_72431_c(new Vec3d(0.0, 0.0, 1.0)).func_72432_b();
        int steps = Math.max(MathHelper.func_76128_c((double)(distance / (maxOffset * 2.0))), 4);
        double lineLength = distance / (double)steps;
        for (int i = 0; i < boltCount; ++i) {
            ElectricFieldRenderUtil.renderSingleElectricLineBetween(startOffset, direction, directionOffset, lineLength, steps, maxOffset);
        }
        ElectricFieldRenderUtil.endLineStripBatch();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        EmissiveUtil.postEmissiveTextureRendering();
    }

    private static void renderSingleElectricLineBetween(Vec3d start, Vec3d direction, Vec3d directionOffset, double lineLength, int steps, double offset) {
        ElectricFieldRenderUtil.addVertex(start.field_72450_a, start.field_72448_b, start.field_72449_c, false);
        for (int i = 1; i < steps; ++i) {
            Vec3d offsetVector = ElectricFieldRenderUtil.generateOffsetVector(direction, directionOffset);
            double offsetScale = (double)RANDOM.nextFloat() * offset;
            double vX = start.field_72450_a + direction.field_72450_a * (double)i * lineLength + offsetVector.field_72450_a * offsetScale;
            double vY = start.field_72448_b + direction.field_72448_b * (double)i * lineLength + offsetVector.field_72448_b * offsetScale;
            double vZ = start.field_72449_c + direction.field_72449_c * (double)i * lineLength + offsetVector.field_72449_c * offsetScale;
            ElectricFieldRenderUtil.addVertex(vX, vY, vZ, false);
        }
        ElectricFieldRenderUtil.addVertex(start.field_72450_a + direction.field_72450_a * (double)steps * lineLength, start.field_72448_b + direction.field_72448_b * (double)steps * lineLength, start.field_72449_c + direction.field_72449_c * (double)steps * lineLength, true);
    }

    private static Vec3d generateOffsetVector(Vec3d direction, Vec3d directionOffset) {
        return VectorUtil.rotateAroundAnyAxis(direction, directionOffset, (double)RANDOM.nextFloat() * 360.0);
    }

    public static void renderElectricFieldWithSizeOfEntityAt(Entity entity, double x, double y, double z, int bolts, long seed) {
        ElectricFieldRenderUtil.renderElectricField(entity.field_70130_N / 2.0f, entity.field_70131_O / 2.0f, x, y + (double)(entity.field_70131_O / 2.0f), z, bolts, seed);
    }
}

