/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.texture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.cqr.cqrepoured.client.resources.data.GlowingMetadataSection;

public class AutoGlowingTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ResourceLocation originalTexture;
    protected final ResourceLocation texture;

    public AutoGlowingTexture(ResourceLocation originalTexture, ResourceLocation texture) {
        this.originalTexture = originalTexture;
        this.texture = texture;
    }

    public static ResourceLocation get(ResourceLocation originalTexture) {
        String path = originalTexture.func_110623_a();
        int i = path.lastIndexOf(46);
        ResourceLocation glowingTexture = new ResourceLocation(originalTexture.func_110624_b(), path.substring(0, i) + "_glowing" + path.substring(i));
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (renderManager.field_78724_e.func_110581_b(glowingTexture) == null) {
            renderManager.field_78724_e.func_110579_a(glowingTexture, (ITextureObject)new AutoGlowingTexture(originalTexture, glowingTexture));
        }
        return glowingTexture;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        try (IResource iresource = resourceManager.func_110536_a(this.originalTexture);){
            ITextureObject ito = Minecraft.func_71410_x().field_71446_o.func_110581_b(iresource.func_177241_a());
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            BufferedImage glowingBI = new BufferedImage(bufferedimage.getWidth(), bufferedimage.getHeight(), bufferedimage.getType());
            boolean flag = false;
            boolean flag1 = false;
            if (iresource.func_110528_c()) {
                try {
                    GlowingMetadataSection glowInformation;
                    TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                    if (texturemetadatasection != null) {
                        flag = texturemetadatasection.func_110479_a();
                        flag1 = texturemetadatasection.func_110480_b();
                    }
                    if ((glowInformation = (GlowingMetadataSection)iresource.func_110526_a("glowsections")) != null) {
                        for (Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> area : glowInformation.getGlowingSections()) {
                            for (int ix = ((Integer)((Tuple)area.func_76341_a()).func_76341_a()).intValue(); ix < (Integer)((Tuple)area.func_76340_b()).func_76341_a(); ++ix) {
                                for (int iy = ((Integer)((Tuple)area.func_76341_a()).func_76340_b()).intValue(); iy < (Integer)((Tuple)area.func_76340_b()).func_76340_b(); ++iy) {
                                    glowingBI.setRGB(ix, iy, bufferedimage.getRGB(ix, iy));
                                    bufferedimage.setRGB(ix, iy, 0);
                                }
                            }
                        }
                    }
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.warn("Failed reading metadata of: {}", (Object)this.originalTexture, (Object)runtimeexception);
                }
            }
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)glowingBI, (boolean)flag, (boolean)flag1);
            TextureUtil.func_110987_a((int)ito.func_110552_b(), (BufferedImage)bufferedimage);
        }
    }
}

