/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.model.entity.boss;

import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import team.cqr.cqrepoured.client.model.geo.ModelGeoCQRBase;
import team.cqr.cqrepoured.entity.boss.exterminator.EntityCQRExterminator;

public class ModelExterminator
extends ModelGeoCQRBase<EntityCQRExterminator> {
    static final ResourceLocation ANIMATION_RESLOC = new ResourceLocation("cqrepoured", "animations/exterminator.animation.json");
    private static final String BONE_IDENT_LEFT_LEG = "leg_left";
    private static final String BONE_IDENT_RIGHT_LEG = "leg_right";
    private static final String BONE_IDENT_TORSO = "body";

    public ModelExterminator(ResourceLocation model, ResourceLocation textureDefault, String entityName) {
        super(model, textureDefault, entityName);
    }

    public ResourceLocation getAnimationFileLocation(EntityCQRExterminator animatable) {
        return ANIMATION_RESLOC;
    }

    private float triangleWave(float p_78172_1_, float p_78172_2_) {
        return (Math.abs(p_78172_1_ % p_78172_2_ - p_78172_2_ * 0.5f) - p_78172_2_ * 0.25f) / (p_78172_2_ * 0.25f);
    }

    public void setLivingAnimations(EntityCQRExterminator entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        if ((double)entity.func_110143_aJ() < 0.01 || entity.field_70128_L || !entity.func_70089_S()) {
            return;
        }
        try {
            float partialTicks = customPredicate.getPartialTick();
            if (!(!((double)entity.field_70721_aZ >= 0.01) || entity.isCannonRaised() || entity.getCurrentAnimation() != null && entity.getCurrentAnimation().equalsIgnoreCase("animation.exterminator.throw"))) {
                IBone torsoBone = this.getAnimationProcessor().getBone(BONE_IDENT_TORSO);
                float f1 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks) + 6.0f;
                float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
                torsoBone.setRotationZ((float)Math.toRadians(6.5f * f2));
            }
            float limbSwingAmount = Math.min(entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks, 1.0f);
            float limbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            float legAngle = 1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
            IBone leftLeg = this.getAnimationProcessor().getBone(BONE_IDENT_LEFT_LEG);
            IBone rightLeg = this.getAnimationProcessor().getBone(BONE_IDENT_RIGHT_LEG);
            if (!entity.isUsingKickAnimation()) {
                rightLeg.setRotationX(legAngle);
            }
            leftLeg.setRotationX(-legAngle);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

