/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import team.cqr.cqrepoured.block.BlockExporterChest;
import team.cqr.cqrepoured.client.util.SphereRenderer;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRItems;

@Mod.EventBusSubscriber(modid="cqrepoured", value={Side.CLIENT})
public class CQRItemModels {
    private static final List<Item> REGISTERED_ITEM_MODELS = new ArrayList<Item>();

    @SubscribeEvent
    public static void registerItemModels(ModelRegistryEvent event) {
        for (Block block : BlockExporterChest.getExporterChests()) {
            ModelLoader.setCustomStateMapper((Block)block, stateMapper -> Collections.emptyMap());
        }
        for (Item item : CQRItems.EventHandler.SPAWN_EGGS) {
            String registryName = item.getRegistryName().toString();
            CQRItemModels.registerCustomItemModel(item, 0, registryName.substring(0, registryName.length() - 2), "inventory");
        }
        for (Item item : CQRItems.EventHandler.ITEMS) {
            if (REGISTERED_ITEM_MODELS.contains(item)) continue;
            CQRItemModels.registerItemModel(item);
        }
        for (ItemBlock itemBlock : CQRBlocks.EventHandler.ITEM_BLOCKS) {
            if (REGISTERED_ITEM_MODELS.contains(itemBlock)) continue;
            CQRItemModels.registerItemModel((Item)itemBlock);
        }
        SphereRenderer.init();
    }

    private static void registerItemModel(Item item) {
        CQRItemModels.registerCustomItemModel(item, 0, item.getRegistryName().toString(), "inventory");
    }

    private static void registerCustomItemModel(Item item, int meta, String modelLocation, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(modelLocation, variant));
        REGISTERED_ITEM_MODELS.add(item);
    }
}

