/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui.npceditor;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.gui.GuiButtonTextured;
import team.cqr.cqrepoured.client.gui.IUpdatableGui;
import team.cqr.cqrepoured.client.gui.npceditor.GuiButtonTrade;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.trade.Trade;
import team.cqr.cqrepoured.entity.trade.TraderOffer;
import team.cqr.cqrepoured.inventory.ContainerMerchant;
import team.cqr.cqrepoured.network.client.packet.CPacketContainerClickButton;

@SideOnly(value=Side.CLIENT)
public class GuiMerchant
extends GuiContainer
implements IUpdatableGui {
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("cqrepoured", "textures/gui/container/gui_merchant.png");
    private static final ResourceLocation BG_TEXTURE_CREATIVE = new ResourceLocation("cqrepoured", "textures/gui/container/gui_merchant_creative.png");
    private final AbstractEntityCQR entity;
    private final TraderOffer trades;
    private final GuiButtonTrade[] tradeButtons = new GuiButtonTrade[7];
    private final GuiButton[] pushUpButtons = new GuiButton[this.tradeButtons.length - 1];
    private final GuiButton[] pushDownButtons = new GuiButton[this.tradeButtons.length - 1];
    private final GuiButton[] deleteButtons = new GuiButton[this.tradeButtons.length - 1];
    private final GuiButton[] editButtons = new GuiButton[this.tradeButtons.length - 1];
    private GuiButton addNewTradeButton;
    private int buttonStartIndex = 0;
    private boolean scrollBarClicked;

    public GuiMerchant(Container container, AbstractEntityCQR entity) {
        super(container);
        this.entity = entity;
        this.trades = entity.getTrades();
        this.field_146999_f = 307;
        this.field_147000_g = 166;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < this.tradeButtons.length; ++i) {
            this.tradeButtons[i] = (GuiButtonTrade)this.func_189646_b(new GuiButtonTrade(10 + i, this.field_147003_i + 8, this.field_147009_r + 18 + i * 20, i));
            if (i >= this.tradeButtons.length - 1) continue;
            this.pushUpButtons[i] = this.func_189646_b(new GuiButtonTextured(20 + i, this.field_147003_i - 12, this.field_147009_r + 18 + i * 20, 10, 10, "", "container/gui_button_10px", "container/icon_up"));
            this.pushDownButtons[i] = this.func_189646_b(new GuiButtonTextured(30 + i, this.field_147003_i - 12, this.field_147009_r + 28 + i * 20, 10, 10, "", "container/gui_button_10px", "container/icon_down"));
            this.deleteButtons[i] = this.func_189646_b(new GuiButtonTextured(40 + i, this.field_147003_i - 2, this.field_147009_r + 18 + i * 20, 10, 10, "", "container/gui_button_10px", "container/icon_delete"));
            this.editButtons[i] = this.func_189646_b(new GuiButtonTextured(50 + i, this.field_147003_i - 2, this.field_147009_r + 28 + i * 20, 10, 10, "", "container/gui_button_10px", "container/icon_edit"));
        }
        this.addNewTradeButton = this.func_189646_b(new GuiButton(0, this.field_147003_i - 12, this.field_147009_r + 138, 136, 20, "- Create Trade -"));
        this.update();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (GuiButtonTrade tradeButton : this.tradeButtons) {
            tradeButton.renderHoveredToolTip(this, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        if (this.field_146297_k.field_71439_g.func_184812_l_()) {
            this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE_CREATIVE);
            GuiHelper.drawTexture((double)this.field_147003_i - 20.0, this.field_147009_r, 0.0, 0.0, (double)this.field_146999_f + 20.0, this.field_147000_g, (double)(this.field_146999_f + 20) / 512.0, (double)this.field_147000_g / 256.0);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE);
            GuiHelper.drawTexture(this.field_147003_i, this.field_147009_r, 0.0, 0.0, this.field_146999_f, this.field_147000_g, (double)this.field_146999_f / 512.0, (double)this.field_147000_g / 256.0);
        }
        if (this.trades.size() > this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0)) {
            int scrollOffsetY = (int)((double)this.buttonStartIndex / (double)(this.trades.size() - (this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0))) * 113.0);
            GuiHelper.drawTexture((double)this.field_147003_i + 125.0, (double)this.field_147009_r + 18.0 + (double)scrollOffsetY, 0.0, 0.6484375, 6.0, 27.0, 0.01171875, 0.10546875);
        } else {
            GuiHelper.drawTexture((double)this.field_147003_i + 125.0, (double)this.field_147009_r + 18.0, 0.01171875, 0.6484375, 6.0, 27.0, 0.01171875, 0.10546875);
        }
        if (this.field_146297_k.field_71439_g.func_184812_l_()) {
            this.field_146289_q.func_78276_b(this.entity.func_145748_c_().func_150254_d(), this.field_147003_i - 13, this.field_147009_r + 7, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(this.entity.func_145748_c_().func_150254_d(), this.field_147003_i + 7, this.field_147009_r + 7, 0x404040);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiButtonTrade) {
            ((ContainerMerchant)this.field_147002_h).setCurrentTradeIndex(((GuiButtonTrade)button).getIndex());
            ((ContainerMerchant)this.field_147002_h).updateInputsForTrade(((GuiButtonTrade)button).getIndex());
        }
        if (button.field_146127_k < 10) {
            if (button.field_146127_k == 0) {
                CQRMain.NETWORK.sendToServer((IMessage)new CPacketContainerClickButton(button.field_146127_k));
            }
        } else {
            int index = this.buttonStartIndex + button.field_146127_k % 10;
            CQRMain.NETWORK.sendToServer((IMessage)new CPacketContainerClickButton(button.field_146127_k, buf -> buf.writeInt(index)));
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        double dWheel = Mouse.getEventDWheel();
        if (dWheel != 0.0) {
            int scrollAmount = (int)(dWheel / 60.0);
            if (this.trades.size() > this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0)) {
                this.buttonStartIndex = MathHelper.func_76125_a((int)(this.buttonStartIndex - scrollAmount), (int)0, (int)(this.trades.size() - (this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0))));
                this.update();
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.scrollBarClicked) {
            int y1 = this.field_147009_r + 18;
            int y2 = y1 + 139;
            int scrollLength = this.trades.size() - (this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0));
            float f = ((float)mouseY - (float)y1 - 13.5f) / ((float)(y2 - y1) - 27.0f);
            f = f * (float)scrollLength + 0.5f;
            this.buttonStartIndex = MathHelper.func_76125_a((int)((int)f), (int)0, (int)scrollLength);
            this.update();
        } else {
            super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.scrollBarClicked = false;
        if (this.trades.size() > this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0) && mouseButton == 0) {
            int x1 = this.field_147003_i + 125;
            int y1 = this.field_147009_r + 18;
            int x2 = x1 + 5;
            int y2 = y1 + 139;
            if (x1 <= mouseX && mouseX <= x2 && y1 <= mouseY && mouseY <= y2) {
                this.scrollBarClicked = true;
            }
        }
    }

    @Override
    public void update() {
        this.buttonStartIndex = this.trades.size() > this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0) ? MathHelper.func_76125_a((int)this.buttonStartIndex, (int)0, (int)(this.trades.size() - (this.tradeButtons.length - (this.field_146297_k.field_71439_g.func_184812_l_() ? 1 : 0)))) : 0;
        for (int i = 0; i < this.tradeButtons.length; ++i) {
            Trade trade = this.trades.get(this.buttonStartIndex + i);
            boolean bl = this.tradeButtons[i].field_146125_m = trade != null && (i < this.tradeButtons.length - 1 || !this.field_146297_k.field_71439_g.func_184812_l_());
            if (trade != null) {
                this.tradeButtons[i].setIndex(this.buttonStartIndex + i);
                this.tradeButtons[i].setTrade(trade);
            }
            if (i >= this.tradeButtons.length - 1) continue;
            this.pushUpButtons[i].field_146125_m = trade != null && this.field_146297_k.field_71439_g.func_184812_l_();
            this.pushDownButtons[i].field_146125_m = trade != null && this.field_146297_k.field_71439_g.func_184812_l_();
            this.deleteButtons[i].field_146125_m = trade != null && this.field_146297_k.field_71439_g.func_184812_l_();
            this.editButtons[i].field_146125_m = trade != null && this.field_146297_k.field_71439_g.func_184812_l_();
        }
        this.addNewTradeButton.field_146125_m = this.field_146297_k.field_71439_g.func_184812_l_();
        this.addNewTradeButton.field_146128_h = this.field_147003_i - 12;
        this.addNewTradeButton.field_146129_i = this.field_147009_r + (this.trades.size() < this.tradeButtons.length - 1 ? 18 + this.trades.size() * 20 : 138);
    }

    public void func_146285_a(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    public int getGuiLeft() {
        return super.getGuiLeft() - (this.field_146297_k.field_71439_g.func_184812_l_() ? 20 : 0);
    }

    public int getXSize() {
        return super.getXSize() + (this.field_146297_k.field_71439_g.func_184812_l_() ? 20 : 0);
    }
}

