/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.client.util.GuiHelper;
import team.cqr.cqrepoured.tileentity.TileEntitySpawner;

@SideOnly(value=Side.CLIENT)
public class GuiSpawner
extends GuiContainer {
    private static final ResourceLocation GUI_SPAWNER = new ResourceLocation("textures/gui/container/dispenser.png");
    private final TileEntitySpawner tileEntity;
    private GuiCheckBox vanillaSpawnerCheckBox;
    private GuiTextField minSpawnDelayTextField;
    private GuiTextField maxSpawnDelayTextField;
    private GuiTextField spawnCountTextField;
    private GuiTextField maxNearbyEntitiesTextField;
    private GuiTextField activatingRangeFromPlayerTextField;
    private GuiTextField spawnRangeTextField;

    public GuiSpawner(TileEntitySpawner tileEntity, Container inventorySlotsIn) {
        super(inventorySlotsIn);
        this.tileEntity = tileEntity;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.vanillaSpawnerCheckBox = (GuiCheckBox)this.func_189646_b((GuiButton)new GuiCheckBox(0, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 80, "Vanilla Spawner", this.tileEntity.isVanillaSpawner()));
        this.minSpawnDelayTextField = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 + 91, this.field_146295_m / 2 - 66, 32, 10);
        this.maxSpawnDelayTextField = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 + 91, this.field_146295_m / 2 - 52, 32, 10);
        this.spawnCountTextField = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 2 + 91, this.field_146295_m / 2 - 38, 32, 10);
        this.maxNearbyEntitiesTextField = new GuiTextField(4, this.field_146289_q, this.field_146294_l / 2 + 91, this.field_146295_m / 2 - 24, 32, 10);
        this.activatingRangeFromPlayerTextField = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 2 + 91, this.field_146295_m / 2 - 10, 32, 10);
        this.spawnRangeTextField = new GuiTextField(6, this.field_146289_q, this.field_146294_l / 2 + 91, this.field_146295_m / 2 + 4, 32, 10);
        this.minSpawnDelayTextField.func_146180_a(Integer.toString(this.tileEntity.getMinSpawnDelay()));
        this.maxSpawnDelayTextField.func_146180_a(Integer.toString(this.tileEntity.getMaxSpawnDelay()));
        this.spawnCountTextField.func_146180_a(Integer.toString(this.tileEntity.getSpawnCount()));
        this.maxNearbyEntitiesTextField.func_146180_a(Integer.toString(this.tileEntity.getMaxNearbyEntities()));
        this.activatingRangeFromPlayerTextField.func_146180_a(Integer.toString(this.tileEntity.getActivatingRangeFromPlayer()));
        this.spawnRangeTextField.func_146180_a(Integer.toString(this.tileEntity.getSpawnRange()));
        if (!this.vanillaSpawnerCheckBox.isChecked()) {
            this.minSpawnDelayTextField.func_146184_c(false);
            this.maxSpawnDelayTextField.func_146184_c(false);
            this.spawnCountTextField.func_146184_c(false);
            this.maxNearbyEntitiesTextField.func_146184_c(false);
            this.activatingRangeFromPlayerTextField.func_146184_c(false);
            this.spawnRangeTextField.func_146184_c(false);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.vanillaSpawnerCheckBox.isChecked()) {
            int minSpawnDelay = 200;
            try {
                minSpawnDelay = Integer.parseInt(this.minSpawnDelayTextField.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int maxSpawnDelay = 800;
            try {
                maxSpawnDelay = Integer.parseInt(this.maxSpawnDelayTextField.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int spawnCount = 4;
            try {
                spawnCount = Integer.parseInt(this.spawnCountTextField.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int maxNearbyEntities = 6;
            try {
                maxNearbyEntities = Integer.parseInt(this.maxNearbyEntitiesTextField.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int activatingRangeFromPlayer = 16;
            try {
                activatingRangeFromPlayer = Integer.parseInt(this.activatingRangeFromPlayerTextField.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int spawnRange = 4;
            try {
                spawnRange = Integer.parseInt(this.spawnRangeTextField.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.tileEntity.setVanillaSpawner(minSpawnDelay, maxSpawnDelay, spawnCount, maxNearbyEntities, activatingRangeFromPlayer, spawnRange);
        } else {
            this.tileEntity.setCQRSpawner();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = "Spawner";
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b("Inventory", 8, 74, 0x404040);
        this.field_146289_q.func_175063_a("Min Spawn Delay", 214.0f, 18.0f, 0xE0E0E0);
        this.field_146289_q.func_175063_a("Max Spawn Delay", 214.0f, 32.0f, 0xE0E0E0);
        this.field_146289_q.func_175063_a("Spawn Count", 214.0f, 46.0f, 0xE0E0E0);
        this.field_146289_q.func_175063_a("Max Nearby Entities", 214.0f, 60.0f, 0xE0E0E0);
        this.field_146289_q.func_175063_a("Activation Range", 214.0f, 74.0f, 0xE0E0E0);
        this.field_146289_q.func_175063_a("Spawn Range", 214.0f, 88.0f, 0xE0E0E0);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        this.minSpawnDelayTextField.func_146194_f();
        this.maxSpawnDelayTextField.func_146194_f();
        this.spawnCountTextField.func_146194_f();
        this.maxNearbyEntitiesTextField.func_146194_f();
        this.activatingRangeFromPlayerTextField.func_146194_f();
        this.spawnRangeTextField.func_146194_f();
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_SPAWNER);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.vanillaSpawnerCheckBox.isChecked()) {
            this.minSpawnDelayTextField.func_146192_a(mouseX, mouseY, mouseButton);
            this.maxSpawnDelayTextField.func_146192_a(mouseX, mouseY, mouseButton);
            this.spawnCountTextField.func_146192_a(mouseX, mouseY, mouseButton);
            this.maxNearbyEntitiesTextField.func_146192_a(mouseX, mouseY, mouseButton);
            this.activatingRangeFromPlayerTextField.func_146192_a(mouseX, mouseY, mouseButton);
            this.spawnRangeTextField.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.vanillaSpawnerCheckBox.isChecked()) {
            this.minSpawnDelayTextField.func_146178_a();
            this.maxSpawnDelayTextField.func_146178_a();
            this.spawnCountTextField.func_146178_a();
            this.maxNearbyEntitiesTextField.func_146178_a();
            this.activatingRangeFromPlayerTextField.func_146178_a();
            this.spawnRangeTextField.func_146178_a();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.vanillaSpawnerCheckBox) {
            boolean flag = this.vanillaSpawnerCheckBox.isChecked();
            this.minSpawnDelayTextField.func_146184_c(flag);
            this.minSpawnDelayTextField.func_146195_b(false);
            this.maxSpawnDelayTextField.func_146184_c(flag);
            this.maxSpawnDelayTextField.func_146195_b(false);
            this.spawnCountTextField.func_146184_c(flag);
            this.spawnCountTextField.func_146195_b(false);
            this.maxNearbyEntitiesTextField.func_146184_c(flag);
            this.maxNearbyEntitiesTextField.func_146195_b(false);
            this.activatingRangeFromPlayerTextField.func_146184_c(flag);
            this.activatingRangeFromPlayerTextField.func_146195_b(false);
            this.spawnRangeTextField.func_146184_c(flag);
            this.spawnRangeTextField.func_146195_b(false);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.minSpawnDelayTextField.func_146206_l() || this.maxSpawnDelayTextField.func_146206_l() || this.spawnCountTextField.func_146206_l() || this.maxNearbyEntitiesTextField.func_146206_l() || this.activatingRangeFromPlayerTextField.func_146206_l() || this.spawnRangeTextField.func_146206_l()) {
            if (keyCode == 1) {
                this.minSpawnDelayTextField.func_146195_b(false);
                this.maxSpawnDelayTextField.func_146195_b(false);
                this.spawnCountTextField.func_146195_b(false);
                this.maxNearbyEntitiesTextField.func_146195_b(false);
                this.activatingRangeFromPlayerTextField.func_146195_b(false);
                this.spawnRangeTextField.func_146195_b(false);
            } else if (GuiHelper.isValidCharForNumberTextField(typedChar, keyCode, false, false)) {
                this.minSpawnDelayTextField.func_146201_a(typedChar, keyCode);
                this.maxSpawnDelayTextField.func_146201_a(typedChar, keyCode);
                this.spawnCountTextField.func_146201_a(typedChar, keyCode);
                this.maxNearbyEntitiesTextField.func_146201_a(typedChar, keyCode);
                this.activatingRangeFromPlayerTextField.func_146201_a(typedChar, keyCode);
                this.spawnRangeTextField.func_146201_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }
}

