/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.CachedBlockAccess;
import team.cqr.cqrepoured.util.PartialTicksUtil;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="cqrepoured", value={Side.CLIENT})
public class EntityRenderManager {
    private static final CachedBlockAccess CACHED_BLOCK_ACCESS = new CachedBlockAccess();
    private static double x;
    private static double y;
    private static double z;
    private static double camX;
    private static double camY;
    private static double camZ;

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            CACHED_BLOCK_ACCESS.setupCached((World)mc.field_71441_e);
            Entity entity = mc.func_175606_aa();
            if (entity != null) {
                double partialTick = PartialTicksUtil.getCurrentPartialTicks();
                x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTick;
                y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * partialTick;
                z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTick;
                Vec3d cam = ActiveRenderInfo.getCameraPosition();
                camX = x + cam.field_72450_a;
                camY = y + cam.field_72448_b;
                camZ = z + cam.field_72449_c;
            }
        } else {
            CACHED_BLOCK_ACCESS.clearCache();
        }
    }

    public static boolean shouldEntityBeRendered(AbstractEntityCQR entity) {
        if (CQRMain.isEntityCullingInstalled) {
            return true;
        }
        if (!entity.func_184222_aU()) {
            return true;
        }
        if (!CQRConfig.advanced.skipHiddenEntityRendering) {
            return true;
        }
        AxisAlignedBB aabb = entity.func_184177_bl();
        double minX = aabb.field_72340_a - 0.5;
        double minY = aabb.field_72338_b - 0.5;
        double minZ = aabb.field_72339_c - 0.5;
        double maxX = aabb.field_72336_d + 0.5;
        double maxY = aabb.field_72337_e + 0.5;
        double maxZ = aabb.field_72334_f + 0.5;
        return EntityRenderManager.isAABBVisible(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static boolean isAABBVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (camX >= minX && camX <= maxX && camY >= minY && camY <= maxY && camZ >= minZ && camZ <= maxZ) {
            return true;
        }
        if (camX < minX ? EntityRenderManager.isPointOnPlaneVisible(minY, maxY, minZ, maxZ, (y, z) -> EntityRenderManager.rayTraceBlocks(minX, y, z)) : camX > maxX && EntityRenderManager.isPointOnPlaneVisible(minY, maxY, minZ, maxZ, (y, z) -> EntityRenderManager.rayTraceBlocks(maxX, y, z))) {
            return true;
        }
        if (camY < minY ? EntityRenderManager.isPointOnPlaneVisible(minX, maxX, minZ, maxZ, (x, z) -> EntityRenderManager.rayTraceBlocks(x, minY, z)) : camY > maxY && EntityRenderManager.isPointOnPlaneVisible(minX, maxX, minZ, maxZ, (x, z) -> EntityRenderManager.rayTraceBlocks(x, maxY, z))) {
            return true;
        }
        return camZ < minZ ? EntityRenderManager.isPointOnPlaneVisible(minX, maxX, minY, maxY, (x, y) -> EntityRenderManager.rayTraceBlocks(x, y, minZ)) : camZ > maxZ && EntityRenderManager.isPointOnPlaneVisible(minX, maxX, minY, maxY, (x, y) -> EntityRenderManager.rayTraceBlocks(x, y, maxZ));
    }

    private static boolean isPointOnPlaneVisible(double min1, double max1, double min2, double max2, BiDoublePredicate predicate) {
        if (predicate.test((min1 + max1) * 0.5, (min2 + max2) * 0.5)) {
            return true;
        }
        if (predicate.test(min1, min2)) {
            return true;
        }
        if (predicate.test(max1, max2)) {
            return true;
        }
        if (predicate.test(min1, max2)) {
            return true;
        }
        return predicate.test(max1, min2);
    }

    private static boolean rayTraceBlocks(double endX, double endY, double endZ) {
        int z;
        int y;
        double threshold = CQRConfig.advanced.skipHiddenEntityRenderingDiff;
        double dirX = endX - camX;
        double dirY = endY - camY;
        double dirZ = endZ - camZ;
        int incX = EntityRenderManager.signum(dirX);
        int incY = EntityRenderManager.signum(dirY);
        int incZ = EntityRenderManager.signum(dirZ);
        double dx = incX == 0 ? Double.MAX_VALUE : (double)incX / dirX;
        double dy = incY == 0 ? Double.MAX_VALUE : (double)incY / dirY;
        double dz = incZ == 0 ? Double.MAX_VALUE : (double)incZ / dirZ;
        double percentX = dx * (incX > 0 ? 1.0 - EntityRenderManager.frac(camX) : EntityRenderManager.frac(camX));
        double percentY = dy * (incY > 0 ? 1.0 - EntityRenderManager.frac(camY) : EntityRenderManager.frac(camY));
        double percentZ = dz * (incZ > 0 ? 1.0 - EntityRenderManager.frac(camZ) : EntityRenderManager.frac(camZ));
        EnumFacing facingX = incX > 0 ? EnumFacing.WEST : EnumFacing.EAST;
        EnumFacing facingY = incY > 0 ? EnumFacing.DOWN : EnumFacing.UP;
        EnumFacing facingZ = incZ > 0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
        int x = EntityRenderManager.floor(camX);
        if (EntityRenderManager.isOpaque(x, y = EntityRenderManager.floor(camY), z = EntityRenderManager.floor(camZ))) {
            double d2 = percentX < percentY ? (percentX < percentZ ? percentX : percentZ) : (percentY < percentZ ? percentY : percentZ);
            d2 = Math.min(d2, 1.0);
            double nextHitX = camX + dirX * d2;
            double nextHitY = camY + dirY * d2;
            double nextHitZ = camZ + dirZ * d2;
            threshold -= Math.sqrt(EntityRenderManager.squareDist(camX, camY, camZ, nextHitX, nextHitY, nextHitZ));
            if (threshold < 0.0) {
                return false;
            }
        }
        while (percentX <= 1.0 || percentY <= 1.0 || percentZ <= 1.0) {
            double nextHitZ;
            double nextHitY;
            EnumFacing facing;
            if (percentX < percentY) {
                if (percentX < percentZ) {
                    x += incX;
                    percentX += dx;
                    facing = facingX;
                } else {
                    z += incZ;
                    percentZ += dz;
                    facing = facingZ;
                }
            } else if (percentY < percentZ) {
                y += incY;
                percentY += dy;
                facing = facingY;
            } else {
                z += incZ;
                percentZ += dz;
                facing = facingZ;
            }
            if (!EntityRenderManager.isOpaque(x, y, z)) continue;
            double d = facing == facingX ? percentX - dx : (facing == facingY ? percentY - dy : percentZ - dz);
            d = Math.min(d, 1.0);
            double hitX = camX + dirX * d;
            double hitY = camY + dirY * d;
            double hitZ = camZ + dirZ * d;
            double d2 = percentX < percentY ? (percentX < percentZ ? percentX : percentZ) : (percentY < percentZ ? percentY : percentZ);
            double nextHitX = camX + dirX * (d2 = Math.min(d2, 1.0));
            if (!((threshold -= Math.sqrt(EntityRenderManager.squareDist(hitX, hitY, hitZ, nextHitX, nextHitY = camY + dirY * d2, nextHitZ = camZ + dirZ * d2))) < 0.0)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOpaque(int x, int y, int z) {
        ExtendedBlockStorage section = CACHED_BLOCK_ACCESS.getChunkSection(x >> 4, y >> 4, z >> 4);
        if (section == null || section.func_76663_a()) {
            return false;
        }
        return section.func_177485_a(x & 0xF, y & 0xF, z & 0xF).func_185914_p();
    }

    private static int signum(double x) {
        if (x == 0.0) {
            return 0;
        }
        return x > 0.0 ? 1 : -1;
    }

    private static double frac(double number) {
        return number - (double)EntityRenderManager.floor(number);
    }

    private static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    private static double squareDist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2 + (z2 -= z1) * z2;
    }

    @FunctionalInterface
    private static interface BiDoublePredicate {
        public boolean test(double var1, double var3);
    }
}

