/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured;

import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;
import team.cqr.cqrepoured.block.banner.BannerHelper;
import team.cqr.cqrepoured.block.banner.EBannerPatternsCQ;
import team.cqr.cqrepoured.block.banner.EBanners;
import team.cqr.cqrepoured.command.CommandChangeReputation;
import team.cqr.cqrepoured.command.CommandDeleteProtectedRegion;
import team.cqr.cqrepoured.command.CommandExport;
import team.cqr.cqrepoured.command.CommandGetProtectedRegion;
import team.cqr.cqrepoured.command.CommandImport;
import team.cqr.cqrepoured.command.CommandLocateDungeon;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.customtextures.TextureSetManager;
import team.cqr.cqrepoured.entity.boss.netherdragon.EntityCQRNetherDragon;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRCapabilities;
import team.cqr.cqrepoured.init.CQRCreatureAttributes;
import team.cqr.cqrepoured.init.CQRDispenseBehaviors;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.init.CQRMaterials;
import team.cqr.cqrepoured.init.CQRMessages;
import team.cqr.cqrepoured.item.crafting.smelting.SmeltingHandler;
import team.cqr.cqrepoured.proxy.IProxy;
import team.cqr.cqrepoured.util.ConfigBackupHandler;
import team.cqr.cqrepoured.util.CopyHelper;
import team.cqr.cqrepoured.util.GuiHandler;
import team.cqr.cqrepoured.world.structure.generation.DungeonRegistry;
import team.cqr.cqrepoured.world.structure.generation.WorldDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.thewall.WorldWallGenerator;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionHelper;

@Mod(modid="cqrepoured", version="2.6.12B", acceptedMinecraftVersions="[1.12,1.12.2]")
public class CQRMain {
    public static final String MODID = "cqrepoured";
    public static final String VERSION = "2.6.12B";
    public static final String ACCEPTED_MINECRAFT_VERSIONS = "[1.12,1.12.2]";
    @Mod.Instance
    public static CQRMain INSTANCE;
    public static final SimpleNetworkWrapper NETWORK;
    @SidedProxy(clientSide="team.cqr.cqrepoured.proxy.ClientProxy", serverSide="team.cqr.cqrepoured.proxy.ServerProxy")
    public static IProxy proxy;
    public static Logger logger;
    public static File CQ_CONFIG_FOLDER;
    public static File CQ_DUNGEON_GRID_FOLDER;
    public static File CQ_DUNGEON_FOLDER;
    public static File CQ_STRUCTURE_FILES_FOLDER;
    public static File CQ_EXPORT_FILES_FOLDER;
    public static File CQ_CHEST_FOLDER;
    public static File CQ_FACTION_FOLDER;
    public static File CQ_INHABITANT_FOLDER;
    public static File CQ_ITEM_FOLDER;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_SETS;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_ROOT;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES;
    public static File CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC;
    public static File CQ_GLOWING_TEXTURES_FOLDER;
    public static boolean isWorkspaceEnvironment;
    public static boolean isPhosphorInstalled;
    public static boolean isEntityCullingInstalled;
    public static boolean isCubicChunksInstalled;
    public static boolean isAW2Installed;
    public static final CreativeTabs CQR_ITEMS_TAB;
    public static final CreativeTabs CQR_BLOCKS_TAB;
    public static final CreativeTabs CQR_CREATIVE_TOOL_TAB;
    public static final CreativeTabs CQR_BANNERS_TAB;
    public static final CreativeTabs CQR_DUNGEON_PLACER_TAB;
    public static final CreativeTabs CQR_EXPORTER_CHEST_TAB;
    public static final CreativeTabs CQR_SPAWN_EGG_TAB;
    public static final WorldDungeonGenerator DUNGEON_GENERATOR;
    public static final WorldWallGenerator WALL_GENERATOR;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GeckoLib.initialize();
        logger = event.getModLog();
        isWorkspaceEnvironment = !CQRMain.class.getResource("").getProtocol().equals("jar");
        this.initConfigFolder(event);
        proxy.preInit();
        GameRegistry.registerWorldGenerator((IWorldGenerator)DUNGEON_GENERATOR, (int)100);
        GameRegistry.registerWorldGenerator((IWorldGenerator)WALL_GENERATOR, (int)101);
        EBannerPatternsCQ.values();
        EBanners.values();
        EnumCreatureAttribute.values();
        CQRCreatureAttributes.VOID.name();
        CQRMessages.registerMessages();
        CQRCapabilities.registerCapabilities();
        CQRLoottables.registerLootTables();
    }

    private void initConfigFolder(FMLPreInitializationEvent event) {
        CQ_CONFIG_FOLDER = new File(event.getModConfigurationDirectory(), "CQR");
        CQ_DUNGEON_FOLDER = new File(CQ_CONFIG_FOLDER, "dungeons");
        CQ_CHEST_FOLDER = new File(CQ_CONFIG_FOLDER, "lootconfigs");
        CQ_STRUCTURE_FILES_FOLDER = new File(CQ_CONFIG_FOLDER, "structures");
        CQ_EXPORT_FILES_FOLDER = new File(CQ_CONFIG_FOLDER, "exporter_output");
        CQ_FACTION_FOLDER = new File(CQ_CONFIG_FOLDER, "factions");
        CQ_INHABITANT_FOLDER = new File(CQ_CONFIG_FOLDER, "dungeon_inhabitants");
        CQ_ITEM_FOLDER = new File(CQ_CONFIG_FOLDER, "items");
        CQ_CUSTOM_TEXTURES_FOLDER_ROOT = new File(CQ_CONFIG_FOLDER, "textures");
        CQ_CUSTOM_TEXTURES_FOLDER_SETS = new File(CQ_CUSTOM_TEXTURES_FOLDER_ROOT, "texture_sets");
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES = new File(CQ_CUSTOM_TEXTURES_FOLDER_ROOT, "textures");
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC = new File(CQ_CUSTOM_TEXTURES_FOLDER_ROOT, "sync");
        CQ_GLOWING_TEXTURES_FOLDER = new File(CQ_CUSTOM_TEXTURES_FOLDER_ROOT, "eyes");
        CQ_DUNGEON_GRID_FOLDER = new File(CQ_CONFIG_FOLDER, "grids");
        File[] subfolders = new File[]{CQ_DUNGEON_FOLDER, CQ_CHEST_FOLDER, CQ_STRUCTURE_FILES_FOLDER, CQ_EXPORT_FILES_FOLDER, CQ_FACTION_FOLDER, CQ_INHABITANT_FOLDER, CQ_ITEM_FOLDER, CQ_CUSTOM_TEXTURES_FOLDER_ROOT, CQ_CUSTOM_TEXTURES_FOLDER_SETS, CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES, CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC, CQ_GLOWING_TEXTURES_FOLDER, CQ_DUNGEON_GRID_FOLDER};
        ConfigBackupHandler.registerConfig(CQ_DUNGEON_FOLDER.getName(), "1.2.0");
        ConfigBackupHandler.registerConfig(CQ_DUNGEON_GRID_FOLDER.getName(), "1.0.0");
        ConfigBackupHandler.registerConfig(CQ_CHEST_FOLDER.getName(), "1.0.0");
        ConfigBackupHandler.registerConfig(CQ_STRUCTURE_FILES_FOLDER.getName(), "1.3.1");
        ConfigBackupHandler.registerConfig(CQ_FACTION_FOLDER.getName(), "1.0.1");
        ConfigBackupHandler.registerConfig(CQ_INHABITANT_FOLDER.getName(), "1.0.0");
        ConfigBackupHandler.registerConfig(CQ_ITEM_FOLDER.getName(), "1.0.0");
        ConfigBackupHandler.registerConfig(CQ_CUSTOM_TEXTURES_FOLDER_ROOT.getName(), "1.1.0");
        if (!CQ_CONFIG_FOLDER.exists() || CQRConfig.general.reinstallDefaultConfigs) {
            CopyHelper.copyFromJarOrWorkspace("/assets/cqrepoured/defaultConfigs", CQ_CONFIG_FOLDER, true);
        } else {
            ConfigBackupHandler.checkAndBackupConfigs();
        }
        int i = CQ_CONFIG_FOLDER.getAbsolutePath().length();
        for (File folder : subfolders) {
            CopyHelper.copyFromJarOrWorkspace("/assets/cqrepoured/defaultConfigs" + folder.getAbsolutePath().substring(i), folder, false);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        CQRMaterials.setRepairItemsForMaterials();
        SmeltingHandler.init();
        BlockFire.func_149843_e();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        isPhosphorInstalled = CQRMain.class.getResource("").getProtocol().equals("jar") && Loader.isModLoaded((String)"phosphor-lighting");
        isEntityCullingInstalled = Loader.isModLoaded((String)"entityculling");
        isCubicChunksInstalled = Loader.isModLoaded((String)"cubicchunks");
        isAW2Installed = Loader.isModLoaded((String)"ancientwarfare");
        DungeonRegistry.getInstance().loadDungeonFiles();
        CQStructure.checkAndUpdateStructureFiles();
        CQStructure.updateSpecialEntities();
        ProtectedRegionHelper.updateWhitelists();
        CQRDispenseBehaviors.registerDispenseBehaviors();
        EntityCQRNetherDragon.reloadBreakableBlocks();
        DungeonInhabitantManager.instance().loadDungeonInhabitants();
    }

    @Mod.EventHandler
    public static void onFMLServerStartingEvent(FMLServerAboutToStartEvent event) {
        TextureSetManager.loadTextureSetsFromFolder(CQ_CUSTOM_TEXTURES_FOLDER_SETS);
        FactionRegistry.getServerInstance().loadFactions();
        CQStructure.cacheFiles();
    }

    @Mod.EventHandler
    public static void onFMLServerStartingEvent(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandExport());
        event.registerServerCommand((ICommand)new CommandChangeReputation());
        event.registerServerCommand((ICommand)new CommandGetProtectedRegion());
        event.registerServerCommand((ICommand)new CommandDeleteProtectedRegion());
        event.registerServerCommand((ICommand)new CommandLocateDungeon());
        event.registerServerCommand((ICommand)new CommandImport());
    }

    @Mod.EventHandler
    public static void onFMLServerStoppingEvent(FMLServerStoppingEvent event) {
        FactionRegistry.getServerInstance().saveAllReputationData(true);
        CQStructure.clearCache();
    }

    static {
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        logger = null;
        CQ_CONFIG_FOLDER = null;
        CQ_DUNGEON_GRID_FOLDER = null;
        CQ_DUNGEON_FOLDER = null;
        CQ_STRUCTURE_FILES_FOLDER = null;
        CQ_EXPORT_FILES_FOLDER = null;
        CQ_CHEST_FOLDER = null;
        CQ_FACTION_FOLDER = null;
        CQ_INHABITANT_FOLDER = null;
        CQ_ITEM_FOLDER = null;
        CQ_CUSTOM_TEXTURES_FOLDER_SETS = null;
        CQ_CUSTOM_TEXTURES_FOLDER_ROOT = null;
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES = null;
        CQ_CUSTOM_TEXTURES_FOLDER_TEXTURES_SYNC = null;
        CQ_GLOWING_TEXTURES_FOLDER = null;
        isWorkspaceEnvironment = true;
        CQR_ITEMS_TAB = new CreativeTabs("cqrepoured_items"){

            public ItemStack func_78016_d() {
                return new ItemStack(CQRItems.BOOTS_CLOUD);
            }
        };
        CQR_BLOCKS_TAB = new CreativeTabs("cqrepoured_blocks"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)CQRBlocks.TABLE_OAK);
            }
        };
        CQR_CREATIVE_TOOL_TAB = new CreativeTabs("cqrepoured_creative_tools"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)CQRBlocks.EXPORTER);
            }
        };
        CQR_BANNERS_TAB = new CreativeTabs("cqrepoured_banners"){

            public ItemStack func_78016_d() {
                return EBanners.WALKER_ORDO.getBanner();
            }

            public void func_78018_a(NonNullList<ItemStack> itemList) {
                super.func_78018_a(itemList);
                List<ItemStack> banners = BannerHelper.addBannersToTabs();
                for (ItemStack stack : banners) {
                    itemList.add((Object)stack);
                }
            }
        };
        CQR_DUNGEON_PLACER_TAB = new CreativeTabs("cqrepoured_dungeon_placers"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(CQRMain.MODID, "dungeon_placer_d5")));
            }
        };
        CQR_EXPORTER_CHEST_TAB = new CreativeTabs("cqrepoured_exporter_chests"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)CQRBlocks.EXPORTER_CHEST_VALUABLE);
            }
        };
        CQR_SPAWN_EGG_TAB = new CreativeTabs("cqrepoured_spawn_eggs"){

            public ItemStack func_78016_d() {
                return new ItemStack(Items.field_151063_bx);
            }
        };
        DUNGEON_GENERATOR = new WorldDungeonGenerator();
        WALL_GENERATOR = new WorldWallGenerator();
    }
}

