/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.iface;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonItemBlock;
import svenhjol.meson.registry.ProxyRegistry;

public interface IMesonBlock {
    default public void register() {
        this.register(this.getName());
    }

    default public void register(String name) {
        Block self = (Block)this;
        ResourceLocation res = new ResourceLocation(this.getModId() + ":" + name);
        self.func_149663_c(res.toString());
        self.setRegistryName(res);
        ProxyRegistry.register(self);
        ProxyRegistry.blocks.add(self);
        this.registerItemBlock(self, name);
    }

    default public void registerItemBlock(Block block, String name) {
        MesonItemBlock itemBlock = null;
        try {
            itemBlock = this.getItemBlockClass().getConstructor(Block.class, String.class).newInstance(block, name);
        }
        catch (Exception e) {
            Meson.runtimeException("Error creating item block");
        }
        itemBlock.func_77625_d(this.getMaxStackSize());
        ProxyRegistry.register(itemBlock);
        ProxyRegistry.items.add((Item)itemBlock);
    }

    default public Class<? extends MesonItemBlock> getItemBlockClass() {
        return MesonItemBlock.class;
    }

    default public String[] getVariants() {
        return new String[]{this.getName()};
    }

    default public int getMaxStackSize() {
        return 64;
    }

    public String getModId();

    public String getName();

    public static interface IHasCustomItemBlockModel {
        public void setInventoryItemModel();
    }

    public static interface IHasCustomStateMapper {
        public void setStateMapper();
    }
}

