/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import svenhjol.meson.helper.EntityHelper;

public class PlayerHelper {
    public static List<String> getBiomeTypes(EntityPlayer player) {
        Set types = BiomeDictionary.getTypes((Biome)player.field_70170_p.func_180494_b(player.func_180425_c()));
        ArrayList<String> actualTypes = new ArrayList<String>();
        types.forEach(type -> actualTypes.add(type.getName()));
        return actualTypes;
    }

    public static List<NonNullList<ItemStack>> getAllInventories(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        return Arrays.asList(inventory.field_70462_a, inventory.field_70460_b, inventory.field_184439_c);
    }

    public static double getLocationAngleToPlayer(EntityPlayer player, BlockPos location) {
        return Math.atan2((double)location.func_177952_p() - player.field_70161_v, (double)location.func_177958_n() - player.field_70165_t);
    }

    public static void replaceHeldItem(EntityPlayer player, EnumHand hand, ItemStack item) {
        player.func_184611_a(hand, item);
    }

    public static void setHeldItem(EntityPlayer player, EnumHand hand, ItemStack item) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190916_E() == 1) {
            player.func_184611_a(hand, item);
        } else {
            stack.func_190918_g(1);
            if (stack.func_190916_E() == 0) {
                player.func_184611_a(hand, item);
            } else {
                PlayerHelper.addOrDropStack(player, item);
            }
        }
    }

    public static boolean addOrDropStack(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
            return false;
        }
        return true;
    }

    public static void addOrDropStacks(EntityPlayer player, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            PlayerHelper.addOrDropStack(player, stack);
        }
    }

    public static void teleportPlayer(EntityPlayer player, BlockPos pos, int dimension) {
        MinecraftServer server;
        if (player.func_130014_f_().field_73011_w.getDimension() != dimension && (server = player.field_70170_p.func_73046_m()) != null) {
            PlayerHelper.transferPlayerToDimension((EntityPlayerMP)player, dimension, server.func_184103_al());
        }
        player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimension, PlayerList manager) {
        int oldDim = player.field_71093_bK;
        WorldServer worldserver = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer worldserver1 = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)player);
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        player.field_70128_L = false;
        EntityHelper.transferEntityToWorld((Entity)player, worldserver, worldserver1);
        manager.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        manager.func_72354_b(player, worldserver1);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        AttributeMap attributeMap = (AttributeMap)player.func_110140_aT();
        Collection watchedAttributes = attributeMap.func_111160_c();
        if (!watchedAttributes.isEmpty()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(player.func_145782_y(), watchedAttributes));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }
}

