/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootHelper {
    private static Map<RARITY, HashMap<TYPE, List<ResourceLocation>>> lootTables = new HashMap<RARITY, HashMap<TYPE, List<ResourceLocation>>>();

    public static ResourceLocation addLootLocation(RARITY rarity, TYPE type, ResourceLocation location) {
        LootHelper.checkLootTable(rarity, type);
        lootTables.get((Object)rarity).get((Object)type).add(location);
        return location;
    }

    public static void addLootLocation(RARITY rarity, TYPE type, List<ResourceLocation> locations) {
        LootHelper.checkLootTable(rarity, type);
        lootTables.get((Object)rarity).get((Object)type).addAll(locations);
    }

    public static void addToVanillaLoot(String modId, LootTable table, ResourceLocation res) {
        LootPool pool = new LootPool(new LootEntry[]{new LootEntryTable(res, 1, 0, new LootCondition[0], modId)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), modId);
        table.addPool(pool);
    }

    public static void addToLootTable(LootTable table, Item item, int weight, int quality, @Nullable LootFunction[] functions, @Nullable LootCondition[] conditions) {
        if (functions == null) {
            functions = new LootFunction[]{};
        }
        if (conditions == null) {
            conditions = new LootCondition[]{};
        }
        LootEntryItem lootItem = new LootEntryItem(item, weight, quality, functions, conditions, Objects.requireNonNull(item.getRegistryName()).toString());
        LootPool pool = table.getPool("main");
        if (pool != null) {
            pool.addEntry((LootEntry)lootItem);
        }
    }

    public static List<ResourceLocation> getLootTables(RARITY rarity, TYPE type) {
        LootHelper.checkLootTable(rarity, type);
        return lootTables.get((Object)rarity).get((Object)type).stream().distinct().collect(Collectors.toList());
    }

    public static ResourceLocation getRandomLootTable(RARITY rarity, TYPE type) {
        List<ResourceLocation> tables = LootHelper.getLootTables(rarity, type);
        return tables.get(new Random().nextInt(tables.size()));
    }

    private static void checkLootTable(RARITY rarity, TYPE type) {
        if (!lootTables.containsKey((Object)rarity)) {
            lootTables.put(rarity, new HashMap());
        }
        if (!lootTables.get((Object)rarity).containsKey((Object)type)) {
            lootTables.get((Object)rarity).put(type, new ArrayList());
        }
    }

    static {
        lootTables.put(RARITY.COMMON, new HashMap<TYPE, List<ResourceLocation>>(){
            {
                this.put(TYPE.MISC, new ArrayList<ResourceLocation>(){
                    {
                        this.add(LootTableList.field_186423_e);
                        this.add(LootTableList.field_186431_m);
                    }
                });
            }
        });
        lootTables.put(RARITY.UNCOMMON, new HashMap<TYPE, List<ResourceLocation>>(){
            {
                this.put(TYPE.MISC, new ArrayList<ResourceLocation>(){
                    {
                        this.add(LootTableList.field_186422_d);
                        this.add(LootTableList.field_186430_l);
                        this.add(LootTableList.field_191192_o);
                        this.add(LootTableList.field_186429_k);
                        this.add(LootTableList.field_186424_f);
                    }
                });
            }
        });
        lootTables.put(RARITY.VALUABLE, new HashMap<TYPE, List<ResourceLocation>>(){
            {
                this.put(TYPE.MISC, new ArrayList<ResourceLocation>(){
                    {
                        this.add(LootTableList.field_186426_h);
                        this.add(LootTableList.field_186427_i);
                        this.add(LootTableList.field_186428_j);
                        this.add(LootTableList.field_186425_g);
                    }
                });
            }
        });
        lootTables.put(RARITY.RARE, new HashMap<TYPE, List<ResourceLocation>>(){
            {
                this.put(TYPE.MISC, new ArrayList<ResourceLocation>(){
                    {
                        this.add(LootTableList.field_186421_c);
                    }
                });
            }
        });
    }

    public static enum TYPE {
        BOOK,
        MISC,
        POTION;

    }

    public static enum RARITY {
        COMMON,
        UNCOMMON,
        VALUABLE,
        RARE,
        SPECIAL;

    }
}

