/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.generator;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import svenhjol.charm.crafting.block.BlockCrate;
import svenhjol.charm.crafting.feature.Crate;
import svenhjol.charm.world.feature.AbandonedCrates;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonBlock;

public class AbandonedCrateGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        float f = random.nextFloat();
        if ((double)f > AbandonedCrates.generateChance) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int upperLimit = AbandonedCrates.upperLimit;
        int lowerLimit = AbandonedCrates.lowerLimit;
        int range = upperLimit - lowerLimit;
        int spread = 10;
        int maxTries = AbandonedCrates.maxTries;
        for (int i = 0; i < maxTries; ++i) {
            IBlockState state;
            BlockPos pos = new BlockPos(x + random.nextInt(spread), lowerLimit + random.nextInt(range), z + random.nextInt(spread));
            if (!world.func_175623_d(pos)) continue;
            while (!(state = world.func_180495_p(pos = pos.func_177972_a(EnumFacing.DOWN))).func_185913_b() && pos.func_177956_o() > lowerLimit) {
            }
            if (!state.func_185913_b()) continue;
            this.placeCrate(world, pos.func_177984_a());
            break;
        }
    }

    public void placeCrate(World world, BlockPos pos) {
        float f = world.field_73012_v.nextFloat();
        Crate.RARITY rarity = Crate.RARITY.COMMON;
        if (f <= AbandonedCrates.rareChance) {
            rarity = Crate.RARITY.RARE;
        } else if (f <= AbandonedCrates.valuableChance) {
            rarity = Crate.RARITY.VALUABLE;
        } else if (f <= AbandonedCrates.uncommonChance) {
            rarity = Crate.RARITY.UNCOMMON;
        }
        IBlockState state = Crate.crateSealed.func_176223_P().func_177226_a(BlockCrate.VARIANT, (Comparable)((Object)MesonBlock.WoodVariant.random()));
        Crate.generateCrate(world, pos, Crate.getRandomCrateType(rarity), state);
        Meson.debug("Abandoned Crates: generated crate", pos);
    }
}

