/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.base.CharmLootTables;
import svenhjol.charm.world.item.ItemBatBucket;
import svenhjol.charm.world.message.MessageGlowing;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.LootHelper;
import svenhjol.meson.helper.PlayerHelper;

public class BatBucket
extends Feature {
    public static ItemBatBucket batBucket;
    public static int maxSeconds;
    public static int range;
    public static boolean addToLoot;
    public static int clientExistingTicks;
    public static double clientRange;
    public static List<Entity> clientEntities;

    @Override
    public String getDescription() {
        return "Right-click a bat with a bucket to capture it.\nRight-click your Bat in a Bucket to release the bat and help locate entities around you.";
    }

    @Override
    public void configure() {
        super.configure();
        maxSeconds = this.propInt("Maximum time", "Maximum time (in seconds) that the glowing effect will last.", 10);
        range = this.propInt("Viewing range", "Range (in blocks) in which entities will glow when the Bat in a Bucket is held.", 24);
        addToLoot = this.propBoolean("Add to loot", "Add the Bat in a Bucket to dungeon loot.", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        batBucket = new ItemBatBucket();
        NetworkHandler.register(MessageGlowing.class, Side.CLIENT);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        EnumHand hand;
        EntityPlayer player;
        ItemStack stack;
        if (!event.isCanceled() && !event.getWorld().field_72995_K && event.getTarget() instanceof EntityBat && ((EntityBat)event.getTarget()).func_110143_aJ() > 0.0f && !(stack = (player = event.getEntityPlayer()).func_184586_b(hand = event.getHand())).func_190926_b() && stack.func_77973_b() == Items.field_151133_ar) {
            ItemStack out = new ItemStack((Item)batBucket);
            PlayerHelper.setHeldItem(player, hand, out);
            event.getTarget().func_70106_y();
        }
        if (event.getWorld().field_72995_K) {
            event.getEntityPlayer().func_184609_a(event.getHand());
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().field_70170_p.field_72995_K) {
            clientExistingTicks = 0;
            this.setGlowing(false);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (clientExistingTicks > 0 && clientRange > 0.0 && event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (clientExistingTicks % 10 == 0 || clientEntities.isEmpty()) {
                this.setGlowing(false);
                this.setNearbyEntities((EntityPlayer)player);
                this.setGlowing(true);
            }
            if (--clientExistingTicks <= 0) {
                this.setGlowing(false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setNearbyEntities(EntityPlayer player) {
        clientEntities.clear();
        AxisAlignedBB area = player.func_174813_aQ().func_72314_b(clientRange, clientRange / 2.0, clientRange);
        Predicate<Entity> selector = entity -> true;
        clientEntities = player.field_70170_p.func_175647_a(Entity.class, area, selector::test);
    }

    @SideOnly(value=Side.CLIENT)
    private void setGlowing(boolean glowing) {
        for (Entity entity : clientEntities) {
            entity.func_184195_f(glowing);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!addToLoot) {
            return;
        }
        int weight = 0;
        int quality = 0;
        LootFunction[] functions = new LootFunction[]{};
        LootCondition[] conditions = new LootCondition[]{};
        if (event.getName().equals((Object)LootTableList.field_186422_d)) {
            weight = 10;
        }
        if (event.getName().equals((Object)CharmLootTables.TREASURE_UNCOMMON)) {
            weight = 10;
        }
        if (weight > 0) {
            LootHelper.addToLootTable(event.getTable(), batBucket, weight, quality, functions, conditions);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        clientEntities = new ArrayList<Entity>();
    }
}

