/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.world.event.SpectreAttackEvent;
import svenhjol.charm.world.feature.Spectre;
import svenhjol.charm.world.feature.SpectreHaunting;
import svenhjol.charm.world.message.MessageSpectreDespawn;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.EnchantmentHelper;

public class EntitySpectre
extends EntityMob {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("charm", "entities/spectre");
    public float eyeHeight = 1.75f;

    public EntitySpectre(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)Spectre.movementSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Spectre.attackDamage);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Spectre.maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)Spectre.trackingRange);
    }

    public boolean func_70652_k(Entity entity) {
        boolean attacked = super.func_70652_k(entity);
        if (attacked && entity instanceof EntityLivingBase) {
            SpectreAttackEvent attackEvent = new SpectreAttackEvent(this, (EntityLivingBase)entity);
            MinecraftForge.EVENT_BUS.post((Event)attackEvent);
            if (attackEvent.getResult() == Event.Result.DENY || attackEvent.isCanceled()) {
                attacked = false;
            }
            if (attacked && entity instanceof EntityPlayer) {
                if (Spectre.applyCurse) {
                    EnchantmentHelper.applyRandomCurse((EntityPlayer)entity);
                } else {
                    ((EntityPlayer)entity).func_70690_d(new PotionEffect(MobEffects.field_76437_t, Spectre.weaknessDuration * 20, Spectre.weaknessAmplifier));
                }
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, CharmSounds.SPECTRE_HIT, SoundCategory.HOSTILE, 1.0f, 1.4f - entity.field_70170_p.field_73012_v.nextFloat() / 2.0f);
            }
            this.despawn();
        }
        return attacked;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean despawn = false;
        BlockPos pos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, pos) > Spectre.despawnLight && this.field_70170_p.func_72935_r()) {
                despawn = true;
            } else if (this.field_70170_p.func_175671_l(pos) >= Spectre.despawnLight) {
                despawn = true;
            }
        }
        if (Charm.hasFeature(SpectreHaunting.class) && this.field_70173_aa > SpectreHaunting.ticksLiving) {
            despawn = true;
        }
        if (despawn) {
            this.despawn();
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h || source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.func_174813_aQ().field_72338_b <= (double)Spectre.spawnDepth;
    }

    public float func_70047_e() {
        return this.eyeHeight;
    }

    public void func_70645_a(DamageSource cause) {
        this.despawn();
    }

    public void despawn() {
        BlockPos pos = this.func_180425_c();
        if (this.field_70170_p instanceof WorldServer && pos != null) {
            NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageSpectreDespawn(pos));
        }
        if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m) {
            this.field_70170_p.func_180501_a(pos.func_177977_b(), Blocks.field_150425_aM.func_176223_P(), 2);
        }
        this.func_70106_y();
    }

    protected SoundEvent func_184615_bR() {
        return CharmSounds.SPECTRE_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return CharmSounds.SPECTRE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return CharmSounds.SPECTRE_HIT;
    }
}

