/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.feature;

import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.ItemHelper;
import svenhjol.meson.helper.PlayerHelper;

public class CauldronWaterSource
extends Feature {
    @Override
    public String getDescription() {
        return "Cauldrons can be used as a permanent water source when sneaking.";
    }

    @SubscribeEvent
    public void onBucketUse(FillBucketEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().func_70093_af()) {
            IBlockState state;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (event.getTarget() != null && this.isFilledCauldron(state = player.func_130014_f_().func_180495_p(event.getTarget().func_178782_a()))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onCauldronUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150383_bp && event.getEntityPlayer() != null) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack held = player.func_184586_b(event.getHand());
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (event.getEntityPlayer().func_70093_af()) {
                if (this.isFilledCauldron(state)) {
                    ItemStack itemToSet = null;
                    if (held.func_77973_b() == Items.field_151069_bo) {
                        itemToSet = ItemHelper.getFilledWaterBottle();
                    } else if (held.func_77973_b() == Items.field_151133_ar) {
                        itemToSet = new ItemStack(Items.field_151131_as);
                    }
                    if (itemToSet != null) {
                        event.setResult(Event.Result.DENY);
                        PlayerHelper.setHeldItem(player, event.getHand(), itemToSet);
                    }
                }
            } else if (held.func_77973_b() == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)held) == PotionTypes.field_185230_b && held.func_190916_E() > 1) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    private boolean isFilledCauldron(IBlockState state) {
        return state.func_177228_b().containsKey((Object)BlockCauldron.field_176591_a) && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 3;
    }
}

