/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.feature;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.enchanting.enchantment.EnchantmentMagnetic;
import svenhjol.charm.enchanting.message.MessageMagneticPickup;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.EnchantmentHelper;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.helper.WorldHelper;

public class Magnetic
extends Feature {
    public static EnchantmentMagnetic enchantment;
    public static int minEnchantability;
    public static Map<BlockPos, EntityPlayer> dropmap;

    @Override
    public String getDescription() {
        return "Tools with the Magnetic enchantment automatically pick up drops.";
    }

    @Override
    public void configure() {
        super.configure();
        minEnchantability = 15;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        enchantment = new EnchantmentMagnetic();
        NetworkHandler.register(MessageMagneticPickup.class, Side.CLIENT);
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        if (EnchantmentHelper.hasEnchantment(enchantment, event.getPlayer().func_184614_ca())) {
            dropmap.put(event.getPos(), event.getPlayer());
        } else {
            dropmap.values().remove(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onEntityCreate(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityItem && !event.getWorld().field_72995_K) {
            int range = 5;
            BlockPos got = null;
            for (BlockPos pos : dropmap.keySet()) {
                double dist = WorldHelper.getDistanceSq(pos, event.getEntity().func_180425_c());
                if (!(dist <= (double)range)) continue;
                got = pos;
                break;
            }
            if (got != null) {
                EntityPlayer player = dropmap.get(got);
                EntityItem fake = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                ItemStack item = ((EntityItem)event.getEntity()).func_92059_d();
                fake.func_92058_a(item);
                dropmap.remove(got);
                if (!MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(player, fake)) && player.field_71071_by.func_70441_a(item)) {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new MessageMagneticPickup(player.func_180425_c()), (EntityPlayerMP)player);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void effectPickup(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        SoundHelper.playSoundAtPos((World)world, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.25f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
    }

    static {
        dropmap = new HashMap<BlockPos, EntityPlayer>();
    }
}

