/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.crafting.tile.TileComposter;
import svenhjol.meson.MesonBlockTE;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.iface.IMesonBlock;

public class BlockComposter
extends MesonBlockTE<TileComposter>
implements IMesonBlock {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)8);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockComposter() {
        super(Material.field_151575_d, "composter");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 1);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.field_149783_u = true;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public Class<TileComposter> getTileEntityClass() {
        return TileComposter.class;
    }

    @Override
    public TileComposter createTileEntity(World world, IBlockState state) {
        return new TileComposter();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean added = false;
        TileComposter composter = (TileComposter)this.getTileEntity((IBlockAccess)world, pos);
        if (this.validTileEntity(composter) && (added = composter.addItem(player.func_184586_b(hand), player.func_184812_l_())) && world.field_72995_K) {
            this.playAddItemSound(world, pos);
            this.spawnParticles(world, pos);
        }
        return added;
    }

    @Override
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)LEVEL);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, BlockPos pos) {
        for (int i = 0; i < 8; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            double dx = (float)pos.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            double dy = (float)pos.func_177956_o() + 1.05f;
            double dz = (float)pos.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, dx, dy, dz, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playAddItemSound(World world, BlockPos pos) {
        SoundHelper.playSoundAtPos(world, pos, SoundEvents.field_187546_ae, 1.0f, 1.0f);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.BOWL : BlockFaceShape.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

