/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BossBlazeReward
extends BossBaseReward {
    public BossBlazeReward() {
        super("demonic_blaze");
    }

    @Override
    public void spawnBoss(final World world, BlockPos pos, final EntityPlayer player, Map<String, Object> settings) {
        final EntityBlaze blaze = new EntityBlaze(world);
        blaze.func_96094_a("Demonic Blaze");
        blaze.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        blaze.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBossHealthDynamic(player, settings));
        blaze.func_70606_j(blaze.func_110138_aP());
        Scheduler.scheduleTask(new Task("blaze_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (blaze.field_70128_L) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.goInvisible(blaze);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.setGroundOnFire(world, player.func_180425_c());
                }
                if (RewardsUtil.rand.nextInt(3) == 4) {
                    BossBlazeReward.this.shootFireballs(world, blaze, player);
                }
            }
        });
        world.func_72838_d((Entity)blaze);
        super.trackEntities(new Entity[]{blaze});
        super.trackedPlayers(player);
    }

    private void goInvisible(EntityBlaze blaze) {
        blaze.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 5));
    }

    private void setGroundOnFire(World world, BlockPos playerPos) {
        for (int xOff = -1; xOff <= 1; ++xOff) {
            for (int zOff = -1; zOff <= 1; ++zOff) {
                BlockPos offPos = playerPos.func_177982_a(xOff, 0, zOff);
                RewardsUtil.placeBlock(Blocks.field_150480_ab.func_176223_P(), world, offPos);
            }
        }
    }

    private void shootFireballs(World world, EntityBlaze blaze, EntityPlayer player) {
        double d1 = player.field_70165_t - blaze.field_70165_t;
        double d2 = player.func_174813_aQ().field_72338_b + (double)(player.field_70131_O / 2.0f) - (blaze.field_70163_u + (double)(blaze.field_70131_O / 2.0f));
        double d3 = player.field_70161_v - blaze.field_70161_v;
        for (int i = 0; i < 5; ++i) {
            EntitySmallFireball entitysmallfireball = new EntitySmallFireball(world, (EntityLivingBase)blaze, d1 + blaze.func_70681_au().nextGaussian(), d2, d3 + blaze.func_70681_au().nextGaussian());
            entitysmallfireball.field_70163_u = blaze.field_70163_u + (double)(blaze.field_70131_O / 2.0f) + 0.5;
            world.func_72838_d((Entity)entitysmallfireball);
        }
    }

    @Override
    public void onBossFightEnd(World world, BlockPos pos, EntityPlayer player) {
    }
}

