/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.profiles;

import chanceCubes.profiles.BasicProfile;
import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.profiles.IProfile;
import chanceCubes.rewards.IChanceCubeReward;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlayerProfileManager {
    private String playerUUID;
    private List<IProfile> enabledProfiles = new ArrayList<IProfile>();
    private List<IProfile> disabledProfiles = new ArrayList<IProfile>();
    private JsonObject playerProfilejson = new JsonObject();

    public PlayerProfileManager(String playerUUID) {
        this.playerUUID = playerUUID;
    }

    public void enableProfile(IProfile profile) {
        if (!this.enabledProfiles.contains(profile)) {
            this.disabledProfiles.remove(profile);
            this.enabledProfiles.add(profile);
            profile.onEnable(this, this.playerUUID);
        }
        this.playerProfilejson.addProperty(profile.getID(), Boolean.valueOf(true));
        GlobalProfileManager.updateProfileSaveFile(this.playerUUID, this.playerProfilejson);
    }

    public void disableProfile(IProfile profile) {
        if (!this.disabledProfiles.contains(profile)) {
            this.enabledProfiles.remove(profile);
            this.disabledProfiles.add(profile);
            profile.onDisable(this, this.playerUUID);
        }
        this.playerProfilejson.addProperty(profile.getID(), Boolean.valueOf(false));
        GlobalProfileManager.updateProfileSaveFile(this.playerUUID, this.playerProfilejson);
    }

    public Map<String, Object> getRewardSpawnSettings(IChanceCubeReward reward) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        for (IProfile prof : this.enabledProfiles) {
            Map<String, Object> rewardSettings = prof.getRewardSettings().get(reward.getName());
            if (rewardSettings == null || rewardSettings.isEmpty()) continue;
            settings.putAll(prof.getRewardSettings().get(reward.getName()));
        }
        return settings;
    }

    public List<IProfile> getAllProfiles() {
        ArrayList<IProfile> toReturn = new ArrayList<IProfile>();
        toReturn.addAll(this.enabledProfiles);
        toReturn.addAll(this.disabledProfiles);
        return toReturn;
    }

    public List<String> getEnabledProfileNames() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (IProfile prof : this.enabledProfiles) {
            toReturn.add(prof.getName());
        }
        return toReturn;
    }

    public List<String> getDisabledProfileNames() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (IProfile prof : this.disabledProfiles) {
            toReturn.add(prof.getName());
        }
        return toReturn;
    }

    public boolean isProfileEnabled(IProfile prof) {
        return this.enabledProfiles.contains(prof);
    }

    public boolean isRewardenabled(String reward) {
        ArrayList<IProfile> topLevelProfiles = new ArrayList<IProfile>();
        for (IProfile profile : this.enabledProfiles) {
            boolean isTopLevel = true;
            for (int i = topLevelProfiles.size() - 1; i >= 0; --i) {
                IProfile topProfile = (IProfile)topLevelProfiles.get(i);
                if (!(profile instanceof BasicProfile) || !(topProfile instanceof BasicProfile)) continue;
                if (((BasicProfile)topProfile).getSubProfiles().contains(profile)) {
                    isTopLevel = false;
                    continue;
                }
                if (!((BasicProfile)profile).getSubProfiles().contains(topProfile)) continue;
                topLevelProfiles.remove(i);
            }
            if (!isTopLevel) continue;
            topLevelProfiles.add(profile);
        }
        for (IProfile profile : topLevelProfiles) {
            if (profile.isRewardEnabled(reward)) continue;
            return false;
        }
        return true;
    }

    public void loadFromJson(JsonObject json) {
        this.playerProfilejson = json;
        for (Map.Entry profileEntry : json.entrySet()) {
            IProfile profile = GlobalProfileManager.getProfileFromID((String)profileEntry.getKey());
            if (profile == null || !((JsonElement)profileEntry.getValue()).isJsonPrimitive()) continue;
            if (((JsonElement)profileEntry.getValue()).getAsBoolean()) {
                this.enableProfile(profile);
                continue;
            }
            this.disabledProfiles.add(profile);
        }
    }

    public void loadFromDefaults(Map<IProfile, Boolean> profileDefaults) {
        for (Map.Entry<IProfile, Boolean> profileEntry : profileDefaults.entrySet()) {
            if (profileEntry.getValue().booleanValue()) {
                this.enableProfile(profileEntry.getKey());
                continue;
            }
            this.disabledProfiles.add(profileEntry.getKey());
        }
    }
}

