/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import capsule.Config;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleTemplate {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleTemplate.class);
    public final List<Template.BlockInfo> blocks = Lists.newArrayList();
    public final List<Template.EntityInfo> entities = Lists.newArrayList();
    public Map<BlockPos, Block> occupiedPositions = null;
    public BlockPos size = BlockPos.field_177992_a;
    public String author = "?";

    public BlockPos getSize() {
        return this.size;
    }

    public void setAuthor(String authorIn) {
        this.author = authorIn;
    }

    public String getAuthor() {
        return this.author;
    }

    public static BlockPos transformedBlockPos(PlacementSettings placementIn, BlockPos pos) {
        return CapsuleTemplate.transformedBlockPos(pos, placementIn.func_186212_b(), placementIn.func_186215_c());
    }

    public static AxisAlignedBB transformedAxisAlignedBB(PlacementSettings placementIn, AxisAlignedBB bb) {
        return new AxisAlignedBB(CapsuleTemplate.transformedBlockPos(new BlockPos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), placementIn.func_186212_b(), placementIn.func_186215_c()), CapsuleTemplate.transformedBlockPos(new BlockPos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f), placementIn.func_186212_b(), placementIn.func_186215_c()));
    }

    private void addEntitiesToWorld(World worldIn, BlockPos pos, Mirror mirrorIn, Rotation rotationIn, @Nullable StructureBoundingBox aabb, List<Entity> spawnedEntities) {
        for (Template.EntityInfo template$entityinfo : this.entities) {
            Entity entity;
            BlockPos recenterOffset = CapsuleTemplate.recenterRotation((this.size.func_177958_n() - 1) / 2, mirrorIn, rotationIn);
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(template$entityinfo.field_186248_b, mirrorIn, rotationIn).func_177971_a((Vec3i)pos).func_177971_a((Vec3i)recenterOffset);
            if (aabb != null && !aabb.func_175898_b((Vec3i)blockpos)) continue;
            NBTTagCompound nbttagcompound = template$entityinfo.field_186249_c;
            Vec3d vec3d = CapsuleTemplate.transformedVec3d(template$entityinfo.field_186247_a, mirrorIn, rotationIn);
            Vec3d vec3d1 = vec3d.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c((double)recenterOffset.func_177958_n(), (double)recenterOffset.func_177956_o(), (double)recenterOffset.func_177952_p());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            nbttagcompound.func_74782_a("Pos", (NBTBase)nbttaglist);
            nbttagcompound.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldIn);
            }
            catch (Exception var15) {
                entity = null;
            }
            if (entity == null) continue;
            float f = entity.func_184217_a(mirrorIn);
            entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(rotationIn), entity.field_70125_A);
            worldIn.func_72838_d(entity);
            if (spawnedEntities == null) continue;
            spawnedEntities.add(entity);
        }
    }

    private static BlockPos transformedBlockPos(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(k, j, -i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-k, j, i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos;
    }

    private static Vec3d transformedVec3d(Vec3d vec, Mirror mirrorIn, Rotation rotationIn) {
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(d2, d1, 1.0 - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - d2, d1, d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - d0, d1, 1.0 - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : vec;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist = new NBTTagList();
        for (Template.BlockInfo blockInfo : this.blocks) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("pos", (NBTBase)this.writeInts(blockInfo.field_186242_a.func_177958_n(), blockInfo.field_186242_a.func_177956_o(), blockInfo.field_186242_a.func_177952_p()));
            nBTTagCompound.func_74768_a("state", template$basicpalette.idFor(blockInfo.field_186243_b));
            if (blockInfo.field_186244_c != null) {
                nBTTagCompound.func_74782_a("nbt", (NBTBase)blockInfo.field_186244_c);
            }
            nbttaglist.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        for (Template.EntityInfo entityInfo : this.entities) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74782_a("pos", (NBTBase)this.writeDoubles(entityInfo.field_186247_a.field_72450_a, entityInfo.field_186247_a.field_72448_b, entityInfo.field_186247_a.field_72449_c));
            nbttagcompound1.func_74782_a("blockPos", (NBTBase)this.writeInts(entityInfo.field_186248_b.func_177958_n(), entityInfo.field_186248_b.func_177956_o(), entityInfo.field_186248_b.func_177952_p()));
            if (entityInfo.field_186249_c != null) {
                nbttagcompound1.func_74782_a("nbt", (NBTBase)entityInfo.field_186249_c);
            }
            nbttaglist1.func_74742_a((NBTBase)nbttagcompound1);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (IBlockState iblockstate : template$basicpalette) {
            nBTTagList.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)iblockstate));
        }
        FMLCommonHandler.instance().getDataFixer().writeVersionData(nbt);
        nbt.func_74782_a("palette", (NBTBase)nBTTagList);
        nbt.func_74782_a("blocks", (NBTBase)nbttaglist);
        nbt.func_74782_a("entities", (NBTBase)nbttaglist1);
        nbt.func_74782_a("size", (NBTBase)this.writeInts(this.size.func_177958_n(), this.size.func_177956_o(), this.size.func_177952_p()));
        nbt.func_74778_a("author", this.author);
        nbt.func_74768_a("DataVersion", 1343);
        NBTTagList nBTTagList2 = new NBTTagList();
        if (this.occupiedPositions != null) {
            for (Map.Entry<BlockPos, Block> entry : this.occupiedPositions.entrySet()) {
                NBTTagCompound nbtEntry = new NBTTagCompound();
                nbtEntry.func_74772_a("pos", entry.getKey().func_177986_g());
                nbtEntry.func_74768_a("blockId", Block.func_149682_b((Block)entry.getValue()));
                nBTTagList2.func_74742_a((NBTBase)nbtEntry);
            }
            nbt.func_74782_a("capsule_occupiedSources", (NBTBase)nBTTagList2);
        }
        return nbt;
    }

    public void read(NBTTagCompound compound) {
        this.blocks.clear();
        this.entities.clear();
        NBTTagList nbttaglist = compound.func_150295_c("size", 3);
        this.size = new BlockPos(nbttaglist.func_186858_c(0), nbttaglist.func_186858_c(1), nbttaglist.func_186858_c(2));
        this.author = compound.func_74779_i("author");
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist1 = compound.func_150295_c("palette", 10);
        for (int i = 0; i < nbttaglist1.func_74745_c(); ++i) {
            template$basicpalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)nbttaglist1.func_150305_b(i)), i);
        }
        NBTTagList nbttaglist3 = compound.func_150295_c("blocks", 10);
        for (int j = 0; j < nbttaglist3.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist3.func_150305_b(j);
            NBTTagList nbttaglist2 = nbttagcompound.func_150295_c("pos", 3);
            BlockPos blockpos = new BlockPos(nbttaglist2.func_186858_c(0), nbttaglist2.func_186858_c(1), nbttaglist2.func_186858_c(2));
            IBlockState iblockstate = template$basicpalette.stateFor(nbttagcompound.func_74762_e("state"));
            if (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a) continue;
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74764_b("nbt") ? nbttagcompound.func_74775_l("nbt") : null;
            this.blocks.add(new Template.BlockInfo(blockpos, iblockstate, nbttagcompound1));
        }
        NBTTagList nbttaglist4 = compound.func_150295_c("entities", 10);
        for (int k = 0; k < nbttaglist4.func_74745_c(); ++k) {
            NBTTagCompound nbttagcompound3 = nbttaglist4.func_150305_b(k);
            NBTTagList nbttaglist5 = nbttagcompound3.func_150295_c("pos", 6);
            Vec3d vec3d = new Vec3d(nbttaglist5.func_150309_d(0), nbttaglist5.func_150309_d(1), nbttaglist5.func_150309_d(2));
            NBTTagList nbttaglist6 = nbttagcompound3.func_150295_c("blockPos", 3);
            BlockPos blockpos1 = new BlockPos(nbttaglist6.func_186858_c(0), nbttaglist6.func_186858_c(1), nbttaglist6.func_186858_c(2));
            if (!nbttagcompound3.func_74764_b("nbt")) continue;
            NBTTagCompound nbttagcompound2 = nbttagcompound3.func_74775_l("nbt");
            this.entities.add(new Template.EntityInfo(vec3d, blockpos1, nbttagcompound2));
        }
        if (compound.func_74764_b("capsule_occupiedSources")) {
            HashMap<BlockPos, Block> occupiedSources = new HashMap<BlockPos, Block>();
            NBTTagList list = compound.func_150295_c("capsule_occupiedSources", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound entry = list.func_150305_b(i);
                occupiedSources.put(BlockPos.func_177969_a((long)entry.func_74763_f("pos")), Block.func_149729_e((int)entry.func_74762_e("blockId")));
            }
            this.occupiedPositions = occupiedSources;
        }
    }

    private NBTTagList writeInts(int ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : values) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        return nbttaglist;
    }

    private NBTTagList writeDoubles(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : values) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    public void removeOccupiedPositions() {
        this.occupiedPositions = null;
    }

    public void saveOccupiedPositions(Map<BlockPos, Block> occupiedPositions) {
        this.occupiedPositions = occupiedPositions;
    }

    public List<BlockPos> snapshotBlocksFromWorld(World worldIn, BlockPos startPos, BlockPos endPos, Map<BlockPos, Block> occupiedPositionsToIgnore, List<Block> excluded, List<Entity> outCapturedEntities) {
        ArrayList<BlockPos> transferedBlocks = new ArrayList<BlockPos>();
        if (endPos.func_177958_n() >= 1 && endPos.func_177956_o() >= 1 && endPos.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)endPos).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.size = endPos;
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos3 = blockpos$mutableblockpos.func_177973_b((Vec3i)blockpos1);
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                Block iblock = iblockstate.func_177230_c();
                if (excluded.contains(iblock) || occupiedPositionsToIgnore != null && occupiedPositionsToIgnore.keySet().contains(blockpos$mutableblockpos) && occupiedPositionsToIgnore.get(blockpos$mutableblockpos).equals(iblock)) continue;
                TileEntity tileentity = worldIn.func_175625_s((BlockPos)blockpos$mutableblockpos);
                if (tileentity != null) {
                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                    nbttagcompound.func_82580_o("x");
                    nbttagcompound.func_82580_o("y");
                    nbttagcompound.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos3, iblockstate, nbttagcompound));
                } else if (!iblockstate.func_185913_b() && !iblockstate.func_185917_h()) {
                    list2.add(new Template.BlockInfo(blockpos3, iblockstate, null));
                } else {
                    list.add(new Template.BlockInfo(blockpos3, iblockstate, null));
                }
                transferedBlocks.add(new BlockPos(blockpos$mutableblockpos.func_177958_n(), blockpos$mutableblockpos.func_177956_o(), blockpos$mutableblockpos.func_177952_p()));
            }
            this.blocks.clear();
            this.blocks.addAll(list);
            this.blocks.addAll(list1);
            this.blocks.addAll(list2);
            List<Entity> capturedEntities = this.snapshotNonLivingEntitiesFromWorld(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1));
            if (outCapturedEntities != null && capturedEntities != null) {
                outCapturedEntities.addAll(capturedEntities);
            }
            return transferedBlocks;
        }
        return transferedBlocks;
    }

    public List<Entity> snapshotNonLivingEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos) {
        List list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), entity -> !(entity instanceof EntityItem) && (!(entity instanceof EntityLivingBase) || entity instanceof EntityArmorStand));
        this.entities.clear();
        for (Entity entity2 : list) {
            Vec3d vec3d = new Vec3d(entity2.field_70165_t - (double)startPos.func_177958_n(), entity2.field_70163_u - (double)startPos.func_177956_o(), entity2.field_70161_v - (double)startPos.func_177952_p());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity2.func_70039_c(nbttagcompound);
            BlockPos blockpos = entity2 instanceof EntityPainting ? ((EntityPainting)entity2).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.entities.add(new Template.EntityInfo(vec3d, blockpos, nbttagcompound));
        }
        return list;
    }

    public void spawnBlocksAndEntities(World worldIn, BlockPos pos, PlacementSettings placementIn, Map<BlockPos, Block> occupiedPositions, List<Block> overridableBlocks, List<BlockPos> outSpawnedBlocks, List<Entity> outSpawnedEntities) {
        BlockRotationProcessor templateProcessor = new BlockRotationProcessor(pos, placementIn);
        if (this.size == null) {
            return;
        }
        StructureBoundingBox structureboundingbox = placementIn.func_186213_g();
        if (!this.blocks.isEmpty() && this.size.func_177958_n() >= 1 && this.size.func_177956_o() >= 1 && this.size.func_177952_p() >= 1) {
            Block block = placementIn.func_186219_f();
            for (Template.BlockInfo template$blockinfo : this.blocks) {
                TileEntity tileentity2;
                TileEntity tileentity;
                BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementIn, template$blockinfo.field_186242_a).func_177971_a((Vec3i)pos).func_177971_a((Vec3i)CapsuleTemplate.recenterRotation((this.size.func_177958_n() - 1) / 2, placementIn));
                Template.BlockInfo template$blockinfo1 = templateProcessor.func_189943_a(worldIn, blockpos, template$blockinfo);
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.field_186243_b.func_177230_c();
                if (block != null && block == block1 || placementIn.func_186227_h() && block1 == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos) || occupiedPositions.containsKey(blockpos) && !overridableBlocks.contains(occupiedPositions.get(blockpos))) continue;
                if (outSpawnedBlocks != null) {
                    outSpawnedBlocks.add(blockpos);
                }
                IBlockState iblockstate = template$blockinfo1.field_186243_b.func_185902_a(placementIn.func_186212_b());
                IBlockState iblockstate1 = iblockstate.func_185907_a(placementIn.func_186215_c());
                if (template$blockinfo1.field_186244_c != null && (tileentity = worldIn.func_175625_s(blockpos)) != null) {
                    if (tileentity instanceof IInventory) {
                        ((IInventory)tileentity).func_174888_l();
                    }
                    worldIn.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 4);
                }
                if (!worldIn.func_180501_a(blockpos, iblockstate1, 2) || template$blockinfo1.field_186244_c == null || (tileentity2 = worldIn.func_175625_s(blockpos)) == null) continue;
                template$blockinfo1.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                template$blockinfo1.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                template$blockinfo1.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                tileentity2.func_145839_a(template$blockinfo1.field_186244_c);
                tileentity2.func_189668_a(placementIn.func_186212_b());
                tileentity2.func_189667_a(placementIn.func_186215_c());
            }
            for (Template.BlockInfo template$blockinfo2 : this.blocks) {
                TileEntity tileentity1;
                if (block != null && block == template$blockinfo2.field_186243_b.func_177230_c()) continue;
                BlockPos blockpos1 = CapsuleTemplate.transformedBlockPos(placementIn, template$blockinfo2.field_186242_a).func_177971_a((Vec3i)pos).func_177971_a((Vec3i)CapsuleTemplate.recenterRotation((this.size.func_177958_n() - 1) / 2, placementIn));
                if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos1)) continue;
                worldIn.func_175722_b(blockpos1, template$blockinfo2.field_186243_b.func_177230_c(), false);
                if (template$blockinfo2.field_186244_c == null || (tileentity1 = worldIn.func_175625_s(blockpos1)) == null) continue;
                tileentity1.func_70296_d();
            }
        }
        if (!placementIn.func_186221_e()) {
            this.addEntitiesToWorld(worldIn, pos, placementIn.func_186212_b(), placementIn.func_186215_c(), structureboundingbox, outSpawnedEntities);
        }
    }

    public void removeBlocks(List<BlockPos> couldNotBeRemoved, BlockPos startPos) {
        for (BlockPos blockPos : couldNotBeRemoved) {
            this.blocks.removeIf(blockInfo -> blockPos.func_177973_b((Vec3i)startPos).equals((Object)blockInfo.field_186242_a));
        }
    }

    public List<BlockPos> calculateDeployPositions(World world, BlockPos blockPos, PlacementSettings placementSettings) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        BlockRotationProcessor blockRotationProcessor = new BlockRotationProcessor(blockPos, placementSettings);
        if (this.size == null) {
            return out;
        }
        if (!this.blocks.isEmpty() && this.size.func_177958_n() >= 1 && this.size.func_177956_o() >= 1 && this.size.func_177952_p() >= 1) {
            Block block = placementSettings.func_186219_f();
            StructureBoundingBox structureboundingbox = placementSettings.func_186213_g();
            for (Template.BlockInfo template$blockinfo : this.blocks) {
                BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementSettings, template$blockinfo.field_186242_a).func_177971_a((Vec3i)blockPos).func_177971_a((Vec3i)CapsuleTemplate.recenterRotation((this.size.func_177958_n() - 1) / 2, placementSettings));
                Template.BlockInfo template$blockinfo1 = blockRotationProcessor.func_189943_a(world, blockpos, template$blockinfo);
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.field_186243_b.func_177230_c();
                if (block != null && block == block1 || placementSettings.func_186227_h() && block1 == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                out.add(blockpos);
            }
        }
        return out;
    }

    public static BlockPos recenterRotation(int extendSize, PlacementSettings placement) {
        return CapsuleTemplate.transformedBlockPos(placement, new BlockPos(-extendSize, 0, -extendSize)).func_177971_a((Vec3i)new BlockPos(extendSize, 0, extendSize));
    }

    public static BlockPos recenterRotation(int extendSize, Mirror m, Rotation r) {
        return CapsuleTemplate.transformedBlockPos(new BlockPos(-extendSize, 0, -extendSize), m, r).func_177971_a((Vec3i)new BlockPos(extendSize, 0, extendSize));
    }

    public boolean canRotate() {
        try {
            for (Template.BlockInfo block : this.blocks) {
                if (block.field_186244_c == null || Config.blueprintWhitelist.keySet().contains(block.field_186243_b.func_177230_c().getRegistryName().toString())) continue;
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public boolean readSchematic(NBTTagCompound nbt) {
        if (!nbt.func_150297_b("Blocks", 7) || !nbt.func_150297_b("Data", 7)) {
            LOGGER.error("Schematic: Missing block data in the schematic");
            return false;
        }
        this.blocks.clear();
        this.entities.clear();
        int width = nbt.func_74765_d("Width");
        int height = nbt.func_74765_d("Height");
        int length = nbt.func_74765_d("Length");
        byte[] blockIdsByte = nbt.func_74770_j("Blocks");
        byte[] metaArr = nbt.func_74770_j("Data");
        int numBlocks = blockIdsByte.length;
        this.author = "?";
        if (numBlocks != width * height * length) {
            LOGGER.error("Schematic: Mismatched block array size compared to the width/height/length, blocks: {}, W x H x L: {} x {} x {}", (Object)numBlocks, (Object)width, (Object)height, (Object)length);
            return false;
        }
        if (numBlocks != metaArr.length) {
            LOGGER.error("Schematic: Mismatched block ID and metadata array sizes, blocks: {}, meta: {}", (Object)numBlocks, (Object)metaArr.length);
            return false;
        }
        Block[] palette = this.readSchematicPalette(nbt);
        if (palette == null || palette.length == 0) {
            LOGGER.error("Schematic: Failed to read the block palette");
            return false;
        }
        IBlockState[] blocksById = this.getSchematicBlocks(nbt, blockIdsByte, metaArr, numBlocks, palette);
        if (blocksById == null) {
            return false;
        }
        Map<BlockPos, NBTTagCompound> tiles = this.getSchematicTiles(nbt);
        this.entities.clear();
        NBTTagList tagList = nbt.func_150295_c("Entities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entityNBT = tagList.func_150305_b(i);
            NBTTagList posList = entityNBT.func_150295_c("Pos", 6);
            Vec3d vec3d = new Vec3d(posList.func_150309_d(0), posList.func_150309_d(1), posList.func_150309_d(2));
            this.entities.add(new Template.EntityInfo(vec3d, new BlockPos(vec3d), entityNBT));
        }
        int index = 0;
        int sizeX = 1;
        int sizeY = 1;
        int sizeZ = 1;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                int x = 0;
                while (x < width) {
                    IBlockState state = blocksById[index];
                    if (state.func_177230_c() != Blocks.field_150350_a) {
                        BlockPos pos = new BlockPos(x, y, z);
                        NBTTagCompound teNBT = tiles.get(pos);
                        this.blocks.add(new Template.BlockInfo(pos, state, teNBT));
                        if (pos.func_177958_n() > sizeX) {
                            sizeX = pos.func_177958_n();
                        }
                        if (pos.func_177956_o() > sizeY) {
                            sizeY = pos.func_177956_o();
                        }
                        if (pos.func_177952_p() > sizeZ) {
                            sizeZ = pos.func_177952_p();
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
        int size = Math.max(sizeX, Math.max(sizeY, sizeZ));
        if (size % 2 == 0) {
            ++size;
        }
        this.size = new BlockPos(size, size, size);
        return true;
    }

    private Map<BlockPos, NBTTagCompound> getSchematicTiles(NBTTagCompound nbt) {
        HashMap<BlockPos, NBTTagCompound> tiles = new HashMap<BlockPos, NBTTagCompound>();
        NBTTagList tagList = nbt.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            tiles.put(pos, tag);
        }
        return tiles;
    }

    @Nullable
    private IBlockState[] getSchematicBlocks(NBTTagCompound nbt, byte[] blockIdsByte, byte[] metaArr, int numBlocks, Block[] palette) {
        IBlockState[] blocksById = new IBlockState[numBlocks];
        if (nbt.func_150297_b("AddBlocks", 7)) {
            Block block;
            int byteId;
            int addValue;
            int expectedAddLength;
            byte[] add = nbt.func_74770_j("AddBlocks");
            if (add.length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
                LOGGER.error("Schematic: Add array size mismatch, blocks: {}, add: {}, expected add: {}", (Object)numBlocks, (Object)add.length, (Object)expectedAddLength);
                return null;
            }
            int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
            int bi = 0;
            int ai = 0;
            while (bi < loopMax) {
                addValue = add[ai] & 0xFF;
                byteId = blockIdsByte[bi] & 0xFF;
                block = palette[(addValue & 0xF0) << 4 | byteId];
                blocksById[bi] = block.func_176203_a((int)metaArr[bi]);
                byteId = blockIdsByte[bi + 1] & 0xFF;
                block = palette[(addValue & 0xF) << 8 | byteId];
                blocksById[bi + 1] = block.func_176203_a((int)metaArr[bi + 1]);
                bi += 2;
                ++ai;
            }
            if (numBlocks % 2 != 0) {
                addValue = add[ai] & 0xFF;
                byteId = blockIdsByte[bi] & 0xFF;
                block = palette[(addValue & 0xF0) << 4 | byteId];
                blocksById[bi] = block.func_176203_a((int)metaArr[bi]);
            }
        } else {
            if (nbt.func_150297_b("Add", 7)) {
                LOGGER.error("Schematic: Old Schematica format detected, not implemented");
                return null;
            }
            if (nbt.func_150297_b("Version", 3)) {
                LOGGER.error("Schematic: Newer Schematica format {} detected, not implemented", (Object)nbt.func_74762_e("Version"));
                return null;
            }
            for (int i = 0; i < numBlocks; ++i) {
                Block block = palette[blockIdsByte[i] & 0xFF];
                blocksById[i] = block.func_176203_a((int)metaArr[i]);
            }
        }
        return blocksById;
    }

    @Nullable
    private Block[] readSchematicPalette(NBTTagCompound nbt) {
        Block air = Blocks.field_150350_a;
        Object[] palette = new Block[4096];
        Arrays.fill(palette, air);
        if (nbt.func_150297_b("SchematicaMapping", 10)) {
            NBTTagCompound tag = nbt.func_74775_l("SchematicaMapping");
            Set keys = tag.func_150296_c();
            for (String key : keys) {
                short id = tag.func_74765_d(key);
                if (id >= palette.length) {
                    LOGGER.error("Schematic: Invalid ID '{}' in SchematicaMapping for block '{}', max = 4095", (Object)id, (Object)key);
                    return null;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    palette[id] = block;
                    continue;
                }
                LOGGER.error("Schematic: Missing/non-existing block '{}' in SchematicaMapping", (Object)key);
            }
        } else if (nbt.func_150297_b("BlockIDs", 10)) {
            NBTTagCompound tag = nbt.func_74775_l("BlockIDs");
            Set keys = tag.func_150296_c();
            for (String idStr : keys) {
                int id;
                String key = tag.func_74779_i(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Schematic: Invalid ID '{}' (not a number) in MCEdit2 palette for block '{}'", (Object)idStr, (Object)key);
                    continue;
                }
                if (id >= palette.length) {
                    LOGGER.error("Schematic: Invalid ID '{}' in MCEdit2 palette for block '{}', max = 4095", (Object)id, (Object)key);
                    return null;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    palette[id] = block;
                    continue;
                }
                LOGGER.error("Schematic: Missing/non-existing block '{}' in MCEdit2 palette", (Object)key);
            }
        } else {
            for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
                if (block == null) continue;
                int id = Block.func_149682_b((Block)block);
                if (id >= 0 && id < palette.length) {
                    palette[id] = block;
                    continue;
                }
                LOGGER.error("Schematic: Invalid ID {} for block '{}' from the registry", (Object)id, (Object)block.getRegistryName());
            }
        }
        return palette;
    }

    static class BasicPalette
    implements Iterable<IBlockState> {
        public static final IBlockState DEFAULT_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
        final ObjectIntIdentityMap<IBlockState> ids = new ObjectIntIdentityMap(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(IBlockState state) {
            int i = this.ids.func_148747_b((Object)state);
            if (i == -1) {
                i = this.lastId++;
                this.ids.func_148746_a((Object)state, i);
            }
            return i;
        }

        @Nullable
        public IBlockState stateFor(int id) {
            IBlockState iblockstate = (IBlockState)this.ids.func_148745_a(id);
            return iblockstate == null ? DEFAULT_BLOCK_STATE : iblockstate;
        }

        @Override
        public Iterator<IBlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockState p_189956_1_, int p_189956_2_) {
            this.ids.func_148746_a((Object)p_189956_1_, p_189956_2_);
        }
    }
}

