/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UpgradeCapsuleRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        Ingredient ing = CraftingHelper.getIngredient((JsonElement)json.getAsJsonArray("ingredients"), (JsonContext)context);
        return new UpgradeCapsuleRecipe(ing);
    }

    public class UpgradeCapsuleRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        public final Ingredient upgradeIngredient;

        public UpgradeCapsuleRecipe(Ingredient upgradeIngredient) {
            this.upgradeIngredient = upgradeIngredient;
        }

        public ItemStack func_77571_b() {
            return CapsuleItems.getUpgradedCapsule(new ItemStack((Item)CapsuleItems.capsule, 1, 0), 1);
        }

        public boolean func_77569_a(InventoryCrafting craftingGrid, World worldIn) {
            ItemStack sourceCapsule = ItemStack.field_190927_a;
            int material = 0;
            for (int i = 0; i < craftingGrid.func_174923_h(); ++i) {
                for (int j = 0; j < craftingGrid.func_174922_i(); ++j) {
                    ItemStack itemstack = craftingGrid.func_70463_b(j, i);
                    if (!itemstack.func_190926_b() && itemstack.func_77973_b() == CapsuleItems.capsule && itemstack.func_77952_i() == 0 && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                        sourceCapsule = itemstack;
                        continue;
                    }
                    if (this.upgradeIngredient.apply(itemstack)) {
                        ++material;
                        continue;
                    }
                    if (itemstack.func_190926_b()) continue;
                    return false;
                }
            }
            return sourceCapsule != null && material > 0 && CapsuleItem.getUpgradeLevel(sourceCapsule) + material <= Config.upgradeLimit;
        }

        public ItemStack func_77572_b(InventoryCrafting craftingGrid) {
            ItemStack input = ItemStack.field_190927_a;
            int material = 0;
            for (int i = 0; i < craftingGrid.func_174923_h(); ++i) {
                for (int j = 0; j < craftingGrid.func_174922_i(); ++j) {
                    ItemStack itemstack = craftingGrid.func_70463_b(j, i);
                    if (!itemstack.func_190926_b() && itemstack.func_77973_b() == CapsuleItems.capsule && itemstack.func_77952_i() == 0 && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                        input = itemstack;
                        continue;
                    }
                    if (this.upgradeIngredient.apply(itemstack)) {
                        ++material;
                        continue;
                    }
                    if (itemstack.func_190926_b()) continue;
                    return ItemStack.field_190927_a;
                }
            }
            if (input == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack copy = input.func_77946_l();
            int newSize = CapsuleItem.getSize(input) + material * 2;
            int newUpgraded = CapsuleItem.getUpgradeLevel(input) + material;
            if (newSize > 255) {
                newSize = 255;
            }
            if (newUpgraded > Config.upgradeLimit) {
                newUpgraded = Config.upgradeLimit;
            }
            CapsuleItem.setSize(copy, newSize);
            CapsuleItem.setUpgradeLevel(copy, newUpgraded);
            return copy;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= 2;
        }

        public boolean func_192399_d() {
            return true;
        }
    }
}

