/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ClearCapsuleRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        return new ClearCapsuleRecipe();
    }

    public class ClearCapsuleRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        public ItemStack func_77571_b() {
            return new ItemStack((Item)CapsuleItems.capsule, 1, 0);
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
                if (!(itemstack.func_77973_b() instanceof CapsuleItem) || itemstack.func_77952_i() == 3) continue;
                ItemStack copy = itemstack.func_77946_l();
                CapsuleItem.setOneUse(copy);
                nonnulllist.set(i, (Object)copy);
            }
            return nonnulllist;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            int sourceCapsule = 0;
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (this.canBeEmptyCapsule(itemstack)) {
                        ++sourceCapsule;
                        continue;
                    }
                    if (itemstack.func_190926_b()) continue;
                    return false;
                }
            }
            return sourceCapsule == 1;
        }

        public boolean canBeEmptyCapsule(ItemStack itemstack) {
            if (!(itemstack.func_77973_b() instanceof CapsuleItem)) {
                return false;
            }
            return CapsuleItem.isLinkedStateCapsule(itemstack) || itemstack.func_77952_i() == 3 && !CapsuleItem.isBlueprint(itemstack);
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (!this.canBeEmptyCapsule(itemstack)) continue;
                    ItemStack copy = itemstack.func_77946_l();
                    CapsuleItem.clearCapsule(copy);
                    return copy;
                }
            }
            return ItemStack.field_190927_a;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= 1;
        }

        public boolean func_192399_d() {
            return true;
        }

        public int getRecipeSize() {
            return 4;
        }
    }
}

