/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlueprintChangeRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        return new BlueprintChangeRecipe();
    }

    public class BlueprintChangeRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        public ItemStack func_77571_b() {
            ItemStack bp = new ItemStack((Item)CapsuleItems.capsule, 1, 3);
            CapsuleItem.setBlueprint(bp);
            CapsuleItem.setBaseColor(bp, 3949738);
            CapsuleItem.setStructureName(bp, "blueprintExampleStructureName");
            return bp;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStack blueprintCapsule = null;
            ItemStack templateCapsule = null;
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (blueprintCapsule == null && CapsuleItem.isBlueprint(itemstack)) {
                        blueprintCapsule = itemstack;
                        continue;
                    }
                    if (!CapsuleItem.hasStructureLink(itemstack)) continue;
                    templateCapsule = itemstack;
                    nonnulllist.set(3 * i + j, (Object)templateCapsule.func_77946_l());
                }
            }
            return nonnulllist;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            int sourceCapsule = 0;
            int blueprint = 0;
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (blueprint == 0 && CapsuleItem.isBlueprint(itemstack)) {
                        ++blueprint;
                        continue;
                    }
                    if (CapsuleItem.hasStructureLink(itemstack) && (3 != itemstack.func_77952_i() || CapsuleItem.isBlueprint(itemstack))) {
                        ++sourceCapsule;
                        continue;
                    }
                    if (itemstack.func_190926_b()) continue;
                    return false;
                }
            }
            return sourceCapsule == 1 && blueprint == 1;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            String templateStructure = null;
            Integer templateSize = null;
            ItemStack blueprintCapsule = null;
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (blueprintCapsule == null && CapsuleItem.isBlueprint(itemstack)) {
                        blueprintCapsule = itemstack.func_77946_l();
                        continue;
                    }
                    if (!CapsuleItem.hasStructureLink(itemstack)) continue;
                    templateStructure = CapsuleItem.getStructureName(itemstack);
                    templateSize = CapsuleItem.getSize(itemstack);
                }
            }
            if (templateStructure != null && blueprintCapsule != null) {
                if (blueprintCapsule.func_77978_p() != null) {
                    blueprintCapsule.func_77978_p().func_74778_a("prevStructureName", CapsuleItem.getStructureName(blueprintCapsule));
                }
                CapsuleItem.setStructureName(blueprintCapsule, templateStructure);
                CapsuleItem.setState(blueprintCapsule, 3);
                CapsuleItem.setSize(blueprintCapsule, templateSize);
                CapsuleItem.cleanDeploymentTags(blueprintCapsule);
                return blueprintCapsule;
            }
            return ItemStack.field_190927_a;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= 2;
        }

        public boolean func_192399_d() {
            return true;
        }

        public int getRecipeSize() {
            return 4;
        }
    }
}

