/*
 * Decompiled with CFR 0.152.
 */
package capsule.plugins.jei;

import capsule.Config;
import capsule.blocks.CapsuleBlocks;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.BlueprintCapsuleRecipeFactory;
import capsule.recipes.PrefabsBlueprintCapsuleRecipe;
import capsule.recipes.RecoveryCapsuleRecipeFactory;
import capsule.recipes.UpgradeCapsuleRecipeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.tuple.Pair;

@JEIPlugin
public class CapsulePlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)CapsuleItems.capsule, (ISubtypeRegistry.ISubtypeInterpreter)new CapsuleSubtypeInterpreter());
    }

    public void register(@Nonnull IModRegistry registry) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        Ingredient upgradeIngredient = ((UpgradeCapsuleRecipeFactory.UpgradeCapsuleRecipe)((Object)CapsuleItems.upgradedCapsule.getValue())).upgradeIngredient;
        for (ItemStack capsule : CapsuleItems.capsuleList.keySet()) {
            for (int upLevel = 1; upLevel < Math.min(8, Config.upgradeLimit); ++upLevel) {
                ItemStack capsuleUp = CapsuleItems.getUpgradedCapsule(capsule, upLevel);
                NonNullList ingredients = NonNullList.func_191197_a((int)(upLevel + 1), (Object)upgradeIngredient);
                ingredients.set(0, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{capsule}));
                recipes.add(new ShapelessRecipes("capsule", capsuleUp, ingredients));
            }
            recipes.add(new ShapelessRecipes("capsule", capsule, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{CapsuleItems.getUnlabelledCapsule(capsule)})})));
        }
        ItemStack recoveryCapsule = (ItemStack)CapsuleItems.recoveryCapsule.getKey();
        ItemStack unlabelled = (ItemStack)CapsuleItems.unlabelledCapsule.getKey();
        ItemStack unlabelledDeployed = unlabelled.func_77946_l();
        CapsuleItem.setState(unlabelledDeployed, 3);
        List<ItemStack> blueprintCapsules = CapsuleItems.blueprintCapsules.stream().map(Pair::getKey).collect(Collectors.toList());
        blueprintCapsules.add((ItemStack)CapsuleItems.blueprintChangedCapsule.getKey());
        Ingredient anyBlueprint = Ingredient.func_193369_a((ItemStack[])blueprintCapsules.toArray(new ItemStack[0]));
        Ingredient unlabelledIng = Ingredient.merge(Arrays.asList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{unlabelled}), anyBlueprint, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{recoveryCapsule})));
        recipes.add(((RecoveryCapsuleRecipeFactory.RecoveryCapsuleRecipe)((Object)CapsuleItems.recoveryCapsule.getValue())).recipe);
        for (Pair<ItemStack, IRecipe> r : CapsuleItems.blueprintCapsules) {
            if (r.getValue() instanceof BlueprintCapsuleRecipeFactory.BlueprintCapsuleRecipe) {
                recipes.add(((BlueprintCapsuleRecipeFactory.BlueprintCapsuleRecipe)((Object)r.getValue())).recipe);
                continue;
            }
            if (r.getValue() instanceof PrefabsBlueprintCapsuleRecipe) {
                recipes.add(((PrefabsBlueprintCapsuleRecipe)((Object)r.getValue())).recipe);
                continue;
            }
            recipes.add(r.getValue());
        }
        ItemStack withNewTemplate = (ItemStack)CapsuleItems.blueprintChangedCapsule.getKey();
        CapsuleItem.setStructureName(withNewTemplate, "newTemplate");
        CapsuleItem.setLabel(withNewTemplate, "Changed Template");
        recipes.add(new ShapelessRecipes("capsule", withNewTemplate, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{anyBlueprint, unlabelledIng})));
        registry.addRecipes(recipes, "minecraft.crafting");
        registry.addIngredientInfo(new ArrayList<ItemStack>(CapsuleItems.capsuleList.keySet()), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.capsule"});
        registry.addIngredientInfo((Object)unlabelled, VanillaTypes.ITEM, new String[]{"jei.capsule.desc.linkedCapsule"});
        registry.addIngredientInfo((Object)unlabelledDeployed, VanillaTypes.ITEM, new String[]{"jei.capsule.desc.linkedCapsule"});
        registry.addIngredientInfo((Object)recoveryCapsule, VanillaTypes.ITEM, new String[]{"jei.capsule.desc.recoveryCapsule"});
        registry.addIngredientInfo(Arrays.asList(anyBlueprint.func_193365_a()), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.blueprintCapsule"});
        registry.addIngredientInfo(new ArrayList<ItemStack>(CapsuleItems.opCapsuleList.keySet()), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.opCapsule"});
        registry.addIngredientInfo((Object)new ItemStack((Block)CapsuleBlocks.blockCapsuleMarker), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.capsuleMarker"});
    }

    private static class CapsuleSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        private CapsuleSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack) {
            if (!(itemStack.func_77973_b() instanceof CapsuleItem)) {
                return null;
            }
            String isOP = String.valueOf(itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("overpowered") && itemStack.func_77978_p().func_74767_n("overpowered"));
            String capsuleState = String.valueOf(itemStack.func_77952_i());
            String capsuleColor = String.valueOf(CapsuleItem.getMaterialColor(itemStack));
            String capsuleBlueprint = String.valueOf(CapsuleItem.isBlueprint(itemStack));
            String label = CapsuleItem.getLabel(itemStack);
            return capsuleState + capsuleColor + isOP + capsuleBlueprint + label;
        }
    }
}

