/*
 * Decompiled with CFR 0.152.
 */
package capsule.network.server;

import capsule.CommonProxy;
import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleThrowQueryToServer;
import capsule.network.CapsuleUndeployNotifToClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleThrowQueryHandler
implements IMessageHandler<CapsuleThrowQueryToServer, IMessage> {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleThrowQueryHandler.class);

    public IMessage onMessage(CapsuleThrowQueryToServer message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            LOGGER.error("CapsuleThrowQueryToServer received on wrong side:" + ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            LOGGER.error("CapsuleThrowQueryToServer was invalid" + message.toString());
            return null;
        }
        EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            LOGGER.error("EntityPlayerMP was null when CapsuleThrowQueryToServer was received");
            return null;
        }
        WorldServer world = sendingPlayer.func_71121_q();
        world.func_152344_a(() -> {
            ItemStack heldItem = sendingPlayer.func_184614_ca();
            if (heldItem.func_77973_b() instanceof CapsuleItem) {
                if (message.instant && message.pos != null) {
                    int size = CapsuleItem.getSize(heldItem);
                    int extendLength = (size - 1) / 2;
                    if (heldItem.func_77952_i() == 0) {
                        boolean captured = Capsule.captureAtPosition(heldItem, sendingPlayer.func_70005_c_(), size, world, message.pos);
                        if (captured) {
                            BlockPos center = message.pos.func_177982_a(0, size / 2, 0);
                            CommonProxy.simpleNetworkWrapper.sendToAllAround((IMessage)new CapsuleUndeployNotifToClient(center, sendingPlayer.func_180425_c(), size), new NetworkRegistry.TargetPoint(sendingPlayer.field_71093_bK, (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), (double)(200 + size)));
                        }
                    } else {
                        boolean deployed = Capsule.deployCapsule(heldItem, message.pos.func_177982_a(0, -1, 0), sendingPlayer.func_70005_c_(), extendLength, world);
                        if (deployed) {
                            world.func_184133_a(null, message.pos, SoundEvents.field_187596_cD, SoundCategory.BLOCKS, 0.4f, 0.1f);
                            Capsule.showDeployParticules(world, message.pos, size);
                        }
                        if (deployed && CapsuleItem.isOneUse(heldItem)) {
                            heldItem.func_190918_g(1);
                        }
                    }
                }
                if (!message.instant) {
                    Capsule.throwCapsule(heldItem, (EntityPlayer)sendingPlayer, message.pos);
                }
            }
        });
        return null;
    }
}

