/*
 * Decompiled with CFR 0.152.
 */
package capsule.loot;

import capsule.Config;
import capsule.helpers.Capsule;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarterLoot {
    protected static final Logger LOGGER = LogManager.getLogger(StarterLoot.class);
    public static StarterLoot instance = new StarterLoot();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            if (StringUtils.func_151246_b((String)Config.starterMode) || Config.starterTemplatesList == null || Config.starterTemplatesList.size() <= 0) {
                LOGGER.info("Capsule starters are disabled in capsule.cfg. To enable, set starterMode to 'all' or 'random' and set a directory path with structures for starterTemplatesPath.");
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            NBTTagCompound playerData = player.getEntityData();
            NBTTagCompound data = !playerData.func_74764_b("PlayerPersisted") ? new NBTTagCompound() : playerData.func_74775_l("PlayerPersisted");
            LOGGER.info("playerLogin: " + (data.func_74767_n("capsule:receivedStarter") ? "already received starters" : "giving starters now"));
            if (!data.func_74767_n("capsule:receivedStarter")) {
                if ("all".equals(Config.starterMode.toLowerCase())) {
                    this.giveAllStarters(player, Config.starterTemplatesList);
                    data.func_74757_a("capsule:receivedStarter", true);
                } else if ("random".equals(Config.starterMode)) {
                    this.giveAllStarters(player, Collections.singletonList(Config.starterTemplatesList.get((int)(Math.random() * (double)Config.starterTemplatesList.size()))));
                    data.func_74757_a("capsule:receivedStarter", true);
                }
                playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
            }
        }
    }

    public void giveAllStarters(EntityPlayerMP player, List<String> allStartersToGive) {
        for (String templatePath : allStartersToGive) {
            ItemStack starterCapsule = Capsule.createLinkedCapsuleFromReward(templatePath, player);
            int stackIdx = player.field_71071_by.func_70447_i();
            if (stackIdx < 0 || stackIdx >= player.field_71071_by.func_70302_i_()) {
                Capsule.throwCapsule(starterCapsule, (EntityPlayer)player, player.func_180425_c());
                continue;
            }
            try {
                player.field_71071_by.func_70299_a(stackIdx, starterCapsule);
            }
            catch (Exception e) {
                Capsule.throwCapsule(starterCapsule, (EntityPlayer)player, player.func_180425_c());
            }
        }
    }
}

