/*
 * Decompiled with CFR 0.152.
 */
package capsule.client;

import capsule.Config;
import capsule.blocks.CaptureTESR;
import capsule.blocks.TileEntityCapture;
import capsule.client.RendererUtils;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class CapsulePreviewHandler {
    public static final Map<String, List<AxisAlignedBB>> currentPreview = new HashMap<String, List<AxisAlignedBB>>();
    private int lastSize = 0;
    private int lastColor = 0;

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            this.tryPreviewRecall(mc.field_71439_g.func_184614_ca());
            this.tryPreviewDeploy(mc.field_71439_g, event.getPartialTicks(), mc.field_71439_g.func_184614_ca());
            this.tryPreviewLinkedInventory(mc.field_71439_g, mc.field_71439_g.func_184614_ca());
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerSP && event.phase.equals((Object)TickEvent.Phase.START)) {
            EntityPlayerSP player = (EntityPlayerSP)event.player;
            this.tryPreviewCapture(player, player.func_184614_ca());
        }
    }

    private boolean tryPreviewCapture(EntityPlayerSP player, ItemStack heldItem) {
        if (!heldItem.func_190926_b()) {
            Item heldItemItem = heldItem.func_77973_b();
            if (heldItemItem instanceof CapsuleItem && (heldItem.func_77952_i() == 0 || heldItem.func_77952_i() == 4)) {
                CapsuleItem capsule = (CapsuleItem)heldItem.func_77973_b();
                if (heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("size")) {
                    this.setCaptureTESizeColor(heldItem.func_77978_p().func_74762_e("size"), CapsuleItem.getBaseColor(heldItem), player.func_130014_f_());
                    return true;
                }
            } else {
                this.setCaptureTESizeColor(0, 0, player.func_130014_f_());
            }
        } else {
            this.setCaptureTESizeColor(0, 0, player.func_130014_f_());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPreviewDeploy(EntityPlayerSP thePlayer, float partialTicks, ItemStack heldItemMainhand) {
        int size;
        RayTraceResult rtc;
        if (heldItemMainhand.func_77973_b() instanceof CapsuleItem && heldItemMainhand.func_77942_o() && (heldItemMainhand.func_77952_i() == 1 || heldItemMainhand.func_77952_i() == 6 || heldItemMainhand.func_77952_i() == 7 || CapsuleItem.getSize(heldItemMainhand) == 1 && heldItemMainhand.func_77952_i() != 3) && (rtc = Spacial.clientRayTracePreview((EntityPlayer)thePlayer, partialTicks, size = CapsuleItem.getSize(heldItemMainhand))) != null && rtc.field_72313_a == RayTraceResult.Type.BLOCK) {
            int extendSize = (size - 1) / 2;
            BlockPos destOriginPos = rtc.func_178782_a().func_177971_a(rtc.field_178784_b.func_176730_m()).func_177963_a((double)(-extendSize), 0.01, (double)(-extendSize));
            String structureName = heldItemMainhand.func_77978_p().func_74779_i("structureName");
            AxisAlignedBB errorBoundingBox = new AxisAlignedBB(0.0, 0.01, 0.0, 1.01, 1.01, 1.01);
            Map<String, List<AxisAlignedBB>> map = currentPreview;
            synchronized (map) {
                if (currentPreview.containsKey(structureName) || size == 1) {
                    BlockPos pos;
                    List<Object> blockspos = new ArrayList();
                    if (size > 1) {
                        blockspos = currentPreview.get(structureName);
                    } else if (heldItemMainhand.func_77952_i() == 0) {
                        pos = rtc.func_178782_a().func_177973_b((Vec3i)destOriginPos);
                        blockspos.add(new AxisAlignedBB(pos, pos));
                    }
                    if (blockspos.isEmpty()) {
                        pos = new BlockPos(extendSize, 0, extendSize);
                        blockspos.add(new AxisAlignedBB(pos, pos));
                    }
                    RendererUtils.doPositionPrologue();
                    RendererUtils.doWirePrologue();
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferBuilder = tessellator.func_178180_c();
                    PlacementSettings placement = CapsuleItem.getPlacement(heldItemMainhand);
                    for (AxisAlignedBB axisAlignedBB : blockspos) {
                        BlockPos recenter = CapsuleTemplate.recenterRotation(extendSize, placement);
                        AxisAlignedBB dest = CapsuleTemplate.transformedAxisAlignedBB(placement, axisAlignedBB).func_72317_d((double)destOriginPos.func_177958_n(), (double)destOriginPos.func_177956_o() + 0.01, (double)destOriginPos.func_177952_p()).func_72317_d((double)recenter.func_177958_n(), (double)recenter.func_177956_o(), (double)recenter.func_177952_p()).func_72321_a(1.0, 1.0, 1.0);
                        int color = 0xDDDDDD;
                        if (heldItemMainhand.func_77952_i() == 0) {
                            GL11.glLineWidth((float)5.0f);
                            color = CapsuleItem.getBaseColor(heldItemMainhand);
                        } else {
                            for (double j = dest.field_72339_c; j < dest.field_72334_f; j += 1.0) {
                                for (double k = dest.field_72338_b; k < dest.field_72337_e; k += 1.0) {
                                    for (double l = dest.field_72340_a; l < dest.field_72336_d; l += 1.0) {
                                        BlockPos pos2 = new BlockPos(l, k, j);
                                        if (Config.overridableBlocks.contains(thePlayer.func_130014_f_().func_180495_p(pos2).func_177230_c())) continue;
                                        GL11.glLineWidth((float)5.0f);
                                        bufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                                        RendererUtils.setColor(0xAA0000, 50);
                                        RendererUtils.drawCapsuleCube(errorBoundingBox.func_186670_a(pos2), bufferBuilder);
                                        tessellator.func_78381_a();
                                    }
                                }
                            }
                        }
                        GL11.glLineWidth((float)1.0f);
                        bufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                        RendererUtils.setColor(color, 50);
                        RendererUtils.drawCapsuleCube(dest, bufferBuilder);
                        tessellator.func_78381_a();
                    }
                    RendererUtils.setColor(0xFFFFFF, 255);
                    RendererUtils.doWireEpilogue();
                    RendererUtils.doPositionEpilogue();
                }
            }
        }
    }

    private void tryPreviewRecall(ItemStack heldItem) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.func_77973_b()) instanceof CapsuleItem && (heldItem.func_77952_i() == 3 || heldItem.func_77952_i() == 7) && heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("spawnPosition")) {
            this.previewRecall(heldItem);
        }
    }

    private void tryPreviewLinkedInventory(EntityPlayerSP player, ItemStack heldItem) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.func_77973_b()) instanceof CapsuleItem && CapsuleItem.isBlueprint(heldItem) && CapsuleItem.hasSourceInventory(heldItem)) {
            BlockPos location = CapsuleItem.getSourceInventoryLocation(heldItem);
            Integer dimension = CapsuleItem.getSourceInventoryDimension(heldItem);
            if (location != null && dimension != null && dimension.equals(player.field_71093_bK) && location.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 3600.0) {
                this.previewLinkedInventory(location, heldItem);
            }
        }
    }

    private void previewLinkedInventory(BlockPos location, ItemStack capsule) {
        float shrink = 0.05f;
        AxisAlignedBB boundingBox = new AxisAlignedBB((double)(shrink + (float)location.func_177958_n()), (double)(shrink + (float)location.func_177956_o()), (double)(shrink + (float)location.func_177952_p()), (double)(1.0f - shrink + (float)location.func_177958_n()), (double)(1.0f - shrink + (float)location.func_177956_o()), (double)(1.0f - shrink + (float)location.func_177952_p()));
        RendererUtils.doPositionPrologue();
        RendererUtils.doOverlayPrologue();
        RendererUtils.setColor(6003967, 80);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        RendererUtils.drawCube(location, 0.0f, bufferBuilder);
        tessellator.func_78381_a();
        RendererUtils.setColor(0xFFFFFF, 255);
        RendererUtils.doOverlayEpilogue();
        RendererUtils.doPositionEpilogue();
    }

    private void previewRecall(ItemStack capsule) {
        if (capsule.func_77978_p() == null) {
            return;
        }
        NBTTagCompound linkPos = capsule.func_77978_p().func_74775_l("spawnPosition");
        int size = CapsuleItem.getSize(capsule);
        int extendSize = (size - 1) / 2;
        int color = CapsuleItem.getBaseColor(capsule);
        CaptureTESR.drawCaptureZone(linkPos.func_74762_e("x") + extendSize, linkPos.func_74762_e("y") - 1, linkPos.func_74762_e("z") + extendSize, size, extendSize, color);
    }

    private void setCaptureTESizeColor(int size, int color, World worldIn) {
        if (size == this.lastSize && color == this.lastColor) {
            return;
        }
        for (TileEntityCapture te : TileEntityCapture.instances) {
            if (te.func_145831_w() != worldIn) continue;
            TileEntityCapture tec = te;
            tec.getTileData().func_74768_a("size", size);
            tec.getTileData().func_74768_a("color", color);
            worldIn.func_175704_b(te.func_174877_v().func_177982_a(-size / 2, -size / 2, -size / 2), te.func_174877_v().func_177982_a(size / 2, size / 2, size / 2));
        }
        this.lastSize = size;
        this.lastColor = color;
    }
}

