/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.helpers.Serialization;
import capsule.loot.LootPathData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    protected static final Logger LOGGER = LogManager.getLogger(Config.class);
    public static Configuration config = null;
    public static List<Block> excludedBlocks;
    public static List<Block> overridableBlocks;
    public static List<Block> opExcludedBlocks;
    public static String[] lootTemplatesPaths;
    public static List<String> lootTablesList;
    public static Map<String, LootPathData> lootTemplatesData;
    public static String starterTemplatesPath;
    public static List<String> starterTemplatesList;
    public static String prefabsTemplatesPath;
    public static String rewardTemplatesPath;
    public static int upgradeLimit;
    public static HashMap<String, JsonObject> blueprintWhitelist;
    public static boolean allowBlueprintReward;
    public static String starterMode;
    public static String enchantRarity;
    public static String recallEnchantType;
    public static Map<String, Integer> capsuleSizes;
    public static Supplier<Integer> ironCapsuleSize;
    public static Supplier<Integer> goldCapsuleSize;
    public static Supplier<Integer> diamondCapsuleSize;
    public static Supplier<Integer> opCapsuleSize;
    public static File configDir;

    public static void readConfig(Configuration config) {
        try {
            Config.config = config;
            config.load();
        }
        catch (Exception e1) {
            LOGGER.error("Problem loading config file !", (Throwable)e1);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void initCaptureConfigs() {
        Property upgradesLimit = config.get("Balancing", "capsuleUpgradesLimit", 10);
        upgradesLimit.setComment("Number of upgrades an empty capsule can get to improve capacity. If <= 0, the capsule won't be able to upgrade.");
        upgradeLimit = upgradesLimit.getInt();
        Block[] defaultExcludedBlocksOP = new Block[]{Blocks.field_150350_a, Blocks.field_189881_dj, Blocks.field_150357_h};
        Block[] defaultExcludedBlocks = new Block[]{Blocks.field_150474_ac, Blocks.field_150384_bq, Blocks.field_150378_br};
        Object[] excludedBlocksOP = (String[])ArrayUtils.addAll((Object[])Serialization.serializeBlockArray(defaultExcludedBlocksOP), (Object[])new String[]{"ic2:", "refinedstorage:", "superfactorymanager:", "gregtech:machine", "gtadditions:", "bloodmagic:alchemy_table", "mekanism:machineblock", "mekanism:boundingblock"});
        String[] excludedBlocks = (String[])ArrayUtils.addAll((Object[])Serialization.serializeBlockArray(defaultExcludedBlocks), (Object[])excludedBlocksOP);
        Property excludedBlocksProp = config.get("Balancing", "excludedBlocks", excludedBlocks);
        excludedBlocksProp.setComment("List of block ids that will never be captured by a non overpowered capsule. While capturing, the blocks will stay in place.\n Ex: minecraft:mob_spawner");
        Block[] exBlocks = null;
        exBlocks = Serialization.deserializeBlockArray(excludedBlocksProp.getStringList());
        Config.excludedBlocks = Arrays.asList(exBlocks);
        Property opExcludedBlocksProp = config.get("Balancing", "opExcludedBlocks", (String[])excludedBlocksOP);
        opExcludedBlocksProp.setComment("List of block ids that will never be captured even with an overpowered capsule. While capturing, the blocks will stay in place.\nMod prefix usually indicate an incompatibility, remove at your own risk. See https://github.com/Lythom/capsule/wiki/Known-incompatibilities. \n Ex: minecraft:mob_spawner");
        Block[] opExBlocks = null;
        opExBlocks = Serialization.deserializeBlockArray(opExcludedBlocksProp.getStringList());
        opExcludedBlocks = Arrays.asList(opExBlocks);
        Block[] defaultOverridable = new Block[]{Blocks.field_150350_a, Blocks.field_150355_j, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150431_aC, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150398_cm};
        Object[] dynamicOverridable = (String[])ForgeRegistries.BLOCKS.getValuesCollection().stream().filter(block -> {
            ResourceLocation registryName = block.getRegistryName();
            String domain = registryName != null ? registryName.func_110624_b() : "";
            String path = registryName != null ? registryName.func_110623_a().toLowerCase() : "";
            if (!Arrays.stream(new String[]{"capsule", "minecraft"}).noneMatch(d -> d.equalsIgnoreCase(domain))) return false;
            if (!Arrays.stream(new String[]{"leaves", "sapling", "mushroom", "vine"}).anyMatch(path::contains)) return false;
            return true;
        }).map(block -> block.getRegistryName().toString()).toArray(String[]::new);
        Property overridableBlocksProp = config.get("Balancing", "overridableBlocks", (String[])ArrayUtils.addAll((Object[])Serialization.serializeBlockArray(defaultOverridable), (Object[])dynamicOverridable));
        overridableBlocksProp.setComment("List of block ids that can be overriden while teleporting blocks.\nPut there blocks that the player don't care about (grass, leaves) so they don't prevent the capsule from deploying.");
        Block[] ovBlocks = null;
        ovBlocks = Serialization.deserializeBlockArray(overridableBlocksProp.getStringList());
        overridableBlocks = Arrays.asList(ovBlocks);
    }

    public static void initLootConfigs() {
        String[] defaultLootTablesList = new String[]{LootTableList.field_186424_f.toString(), LootTableList.field_186429_k.toString(), LootTableList.field_186421_c.toString(), LootTableList.field_186431_m.toString(), LootTableList.field_186430_l.toString(), LootTableList.field_186422_d.toString(), LootTableList.field_186428_j.toString(), LootTableList.field_186427_i.toString(), LootTableList.field_186426_h.toString(), LootTableList.field_186423_e.toString(), LootTableList.field_191192_o.toString()};
        Property lootTablesListProp = config.get("loots", "lootTablesList", defaultLootTablesList);
        lootTablesListProp.setComment("List of loot tables that will eventually reward a capsule.\n Example of valid loot tables : gameplay/fishing/treasure, chests/spawn_bonus_chest, entities/villager (killing a villager).\nAlso see https://minecraft.gamepedia.com/Loot_table#List_of_loot_tables.");
        lootTablesList = new ArrayList<String>(Arrays.asList(lootTablesListProp.getStringList()));
        Property lootTemplatesPathsProp = config.get("loots", "lootTemplatesPaths", new String[]{"config/capsule/loot/common", "config/capsule/loot/uncommon", "config/capsule/loot/rare"});
        lootTemplatesPathsProp.setComment("List of paths where the mod will look for structureBlock files. Each save structure have a chance to appear as a reward capsule in a dungeon chest.\nTo Lower the chance of getting a capsule at all, insert an empty folder here and configure its weight accordingly (more weigth on empty folder = less capsule chance per chest).");
        lootTemplatesPaths = lootTemplatesPathsProp.getStringList();
        Property starterModeProp = config.get("loots", "starterMode", "random");
        starterModeProp.setComment("Players can be given one or several starter structures on their first arrival.\nThose structures nbt files can be placed in the folder defined at starterTemplatesPath below.\nPossible values : \"all\", \"random\", or \"none\".\nDefault value: \"random\"");
        starterMode = starterModeProp.getString();
        Property starterTemplatesPathProp = config.get("loots", "starterTemplatesPath", "config/capsule/starters");
        starterTemplatesPathProp.setComment("Each structure in this folder will be given to the player as standard reusable capsule on game start.\nEmpty the folder or the value to disable starter capsules.\nDefault value: \"config/capsule/starters\"");
        starterTemplatesPath = starterTemplatesPathProp.getString();
        Property prefabsTemplatesPathProp = config.get("loots", "prefabsTemplatesPath", "config/capsule/prefabs");
        prefabsTemplatesPathProp.setComment("Each structure in this folder will auto-generate a blueprint recipe that player will be able to craft.\nRemove/Add structure in the folder to disable/enable the recipe.\nDefault value: \"config/capsule/prefabs\"");
        prefabsTemplatesPath = prefabsTemplatesPathProp.getString();
        Property rewardTemplatesPathProp = config.get("loots", "rewardTemplatesPath", "config/capsule/rewards");
        rewardTemplatesPathProp.setComment("Paths where the mod will look for structureBlock files when invoking command /capsule fromExistingRewards <structureName> [playerName].");
        rewardTemplatesPath = rewardTemplatesPathProp.getString();
        Property allowBlueprintRewardProp = config.get("loots", "allowBlueprintReward", true);
        allowBlueprintRewardProp.setComment("If true, loot rewards will be pre-charged blueprint when possible (if the content contains no entity).\nIf false loot reward will always be one-use capsules.\nDefault value: true");
        allowBlueprintReward = allowBlueprintRewardProp.getBoolean();
        for (int i = 0; i < lootTemplatesPaths.length; ++i) {
            String path = lootTemplatesPaths[i];
            if (!lootTemplatesData.containsKey(path)) {
                lootTemplatesData.put(path, new LootPathData());
            }
            Property pathDataWeight = config.get("loots:" + path, "weight", path.endsWith("rare") ? 2 : (path.endsWith("uncommon") ? 6 : 10));
            pathDataWeight.setComment("Chances to get a capsule from this folder. Higher means more common. Default : 2 (rare), 6 (uncommon) or 10 (common)");
            Config.lootTemplatesData.get((Object)path).weigth = pathDataWeight.getInt();
        }
    }

    public static void initRecipesConfigs() {
        Property woodCapsuleSize = config.get("Balancing", "woodCapsuleSize", "1");
        woodCapsuleSize.setComment("Size of the capture cube side for an Iron Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 1");
        Property ironCapsuleSize = config.get("Balancing", "ironCapsuleSize", "3");
        ironCapsuleSize.setComment("Size of the capture cube side for an Iron Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 3");
        Property goldCapsuleSize = config.get("Balancing", "goldCapsuleSize", "5");
        goldCapsuleSize.setComment("Size of the capture cube side for a Gold Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 5");
        Property diamondCapsuleSize = config.get("Balancing", "diamondCapsuleSize", "7");
        diamondCapsuleSize.setComment("Size of the capture cube side for a Diamond Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 7");
        Property obsidianCapsuleSize = config.get("Balancing", "obsidianCapsuleSize", "9");
        obsidianCapsuleSize.setComment("Size of the capture cube side for an Obsidian Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 9");
        Property emeraldCapsuleSize = config.get("Balancing", "emeraldCapsuleSize", "11");
        emeraldCapsuleSize.setComment("Size of the capture cube side for an Emerald Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 11");
        Property opCapsuleSize = config.get("Balancing", "opCapsuleSize", "1");
        opCapsuleSize.setComment("Size of the capture cube side for a Overpowered Capsule. Must be an Odd Number (or it will be rounded down with error message).\n0 to disable.\nDefault: 1");
        config.getCategory("Balancing").values().forEach(property -> {
            if (property.getName().endsWith("CapsuleSize")) {
                capsuleSizes.put(property.getName(), property.getInt());
            }
        });
    }

    public static void initEnchantsConfigs() {
        Property enchantRarityConfig = config.get("Balancing", "recallEnchantRarity", "RARE");
        enchantRarityConfig.setComment("Rarity of the enchantmant. Possible values : COMMON, UNCOMMON, RARE, VERY_RARE. Default: RARE.");
        enchantRarity = enchantRarityConfig.getString();
        Property recallEnchantTypeConfig = config.get("Balancing", "recallEnchantType", "null");
        recallEnchantTypeConfig.setComment("Possible targets for the enchantment. By default : null.\nPossible values are ALL, ARMOR, ARMOR_FEET, ARMOR_LEGS, ARMOR_TORSO, ARMOR_HEAD, WEAPON, DIGGER, FISHING_ROD, BREAKABLE, BOW, null.\nIf null or empty, Capsules will be the only items to be able to get this Enchantment.");
        recallEnchantType = recallEnchantTypeConfig.getString();
    }

    public static BooleanSupplier isEnabled(String key) {
        return () -> !capsuleSizes.containsKey(key) || capsuleSizes.get(key) > 0;
    }

    public static String getRewardPathFromName(String structureName) {
        return rewardTemplatesPath + "/" + structureName;
    }

    public static JsonObject getBlueprintAllowedNBT(Block b) {
        return blueprintWhitelist.get(b.getRegistryName().toString());
    }

    public static List<String> getBlueprintIdentityNBT(Block b) {
        JsonObject allowedNBT = Config.getBlueprintAllowedNBT(b);
        if (allowedNBT == null) {
            return null;
        }
        return allowedNBT.entrySet().stream().filter(ks -> !((JsonElement)ks.getValue()).isJsonNull()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static {
        lootTemplatesData = new HashMap<String, LootPathData>();
        starterTemplatesList = new ArrayList<String>();
        capsuleSizes = new HashMap<String, Integer>();
        ironCapsuleSize = () -> capsuleSizes.get("ironCapsuleSize");
        goldCapsuleSize = () -> capsuleSizes.get("goldCapsuleSize");
        diamondCapsuleSize = () -> capsuleSizes.get("diamondCapsuleSize");
        opCapsuleSize = () -> capsuleSizes.get("opCapsuleSize");
        configDir = null;
    }
}

