/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.Config;
import capsule.blocks.CapsuleBlocks;
import capsule.command.CapsuleCommand;
import capsule.enchantments.Enchantments;
import capsule.helpers.Files;
import capsule.items.CapsuleItems;
import capsule.loot.CapsuleLootTableHook;
import capsule.loot.StarterLoot;
import capsule.network.CapsuleContentPreviewAnswerToClient;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleLeftClickQueryToServer;
import capsule.network.CapsuleThrowQueryToServer;
import capsule.network.CapsuleUndeployNotifToClient;
import capsule.network.LabelEditedMessageToServer;
import capsule.network.client.CapsuleContentPreviewAnswerHandler;
import capsule.network.client.CapsuleUndeployNotifHandler;
import capsule.network.server.CapsuleContentPreviewQueryHandler;
import capsule.network.server.CapsuleLeftClickQueryHandler;
import capsule.network.server.CapsuleThrowQueryHandler;
import capsule.network.server.LabelEditedMessageToServerHandler;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class CommonProxy {
    public static SimpleNetworkWrapper simpleNetworkWrapper;
    public static byte CAPSULE_CHANNEL_MESSAGE_ID;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        CapsuleBlocks.registerBlocks(event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        CapsuleBlocks.registerItemBlocks(event);
        CapsuleItems.registerItems(event);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ArrayList<String> prefabsTemplatesList = Files.populatePrefabs(Config.configDir, Config.prefabsTemplatesPath);
        CapsuleItems.registerRecipes(event, prefabsTemplatesList);
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        Enchantments.registerEnchantments(event);
    }

    public void preInit(FMLPreInitializationEvent event) {
        Config.configDir = new File(event.getModConfigurationDirectory(), "capsule");
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        Config.readConfig(config);
        Config.initLootConfigs();
        Config.initRecipesConfigs();
        Config.initEnchantsConfigs();
        this.refreshConfigTemplates();
        simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("CapsuleChannel");
        byte by = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by + 1);
        simpleNetworkWrapper.registerMessage(LabelEditedMessageToServerHandler.class, LabelEditedMessageToServer.class, (int)by, Side.SERVER);
        byte by2 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by2 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleContentPreviewQueryHandler.class, CapsuleContentPreviewQueryToServer.class, (int)by2, Side.SERVER);
        byte by3 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by3 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleThrowQueryHandler.class, CapsuleThrowQueryToServer.class, (int)by3, Side.SERVER);
        byte by4 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by4 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleLeftClickQueryHandler.class, CapsuleLeftClickQueryToServer.class, (int)by4, Side.SERVER);
        byte by5 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by5 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleContentPreviewAnswerHandler.class, CapsuleContentPreviewAnswerToClient.class, (int)by5, Side.CLIENT);
        byte by6 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by6 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleUndeployNotifHandler.class, CapsuleUndeployNotifToClient.class, (int)by6, Side.CLIENT);
    }

    public void refreshConfigTemplates() {
        Files.populateAndLoadLootList(Config.configDir, Config.lootTemplatesPaths, Config.lootTemplatesData);
        Config.starterTemplatesList = Files.populateStarters(Config.configDir, Config.starterTemplatesPath);
        Config.blueprintWhitelist = Files.populateWhitelistConfig(Config.configDir);
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Enchantments.recallEnchant);
        MinecraftForge.EVENT_BUS.register((Object)CapsuleItems.capsule);
        MinecraftForge.EVENT_BUS.register((Object)StarterLoot.instance);
    }

    public void postInit(FMLPostInitializationEvent event) {
        Config.initCaptureConfigs();
        if (Config.config.hasChanged()) {
            Config.config.save();
        }
        CapsuleLootTableHook lootTableHook = new CapsuleLootTableHook();
        MinecraftForge.EVENT_BUS.register((Object)lootTableHook);
    }

    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CapsuleCommand());
        this.refreshConfigTemplates();
    }

    public void openGuiScreen(EntityPlayer playerIn) {
    }

    static {
        CAPSULE_CHANNEL_MESSAGE_ID = 1;
    }
}

