/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.config.AutoSync;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.config.PatternList;
import com.direwolf20.buildinggadgets.common.config.fieldmap.FieldMapper;
import com.direwolf20.buildinggadgets.common.config.fieldmap.FieldSerializer;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.PacketSyncConfig;
import com.direwolf20.buildinggadgets.common.tools.ReflectionTool;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class SyncedConfig {
    private static final String KEY_NAME = "NAME";
    private static final String KEY_VALUE = "VAL";
    @AutoSync
    public static int energyCostBuilder;
    @AutoSync
    public static int energyCostExchanger;
    @AutoSync
    public static int energyCostDestruction;
    @AutoSync
    public static int energyCostCopyPaste;
    @AutoSync
    public static int damageCostBuilder;
    @AutoSync
    public static int damageCostExchanger;
    @AutoSync
    public static int damageCostDestruction;
    @AutoSync
    public static int damageCostCopyPaste;
    @AutoSync
    public static int energyMax;
    @AutoSync
    public static int energyMaxDestruction;
    @AutoSync
    public static boolean poweredByFE;
    @AutoSync
    public static int durabilityBuilder;
    @AutoSync
    public static int durabilityExchanger;
    @AutoSync
    public static int durabilityDestruction;
    @AutoSync
    public static double nonFuzzyMultiplierDestruction;
    @AutoSync
    public static boolean nonFuzzyEnabledDestruction;
    @AutoSync
    public static int durabilityCopyPaste;
    @AutoSync
    public static double rayTraceRange;
    @AutoSync
    public static int maxRange;
    @AutoSync
    public static boolean enableDestructionGadget;
    @AutoSync
    public static boolean absoluteCoordDefault;
    @AutoSync
    public static boolean allowAbsoluteCoords;
    @AutoSync
    public static boolean canOverwriteBlocks;
    @AutoSync
    public static boolean enablePaste;
    @AutoSync
    public static int pasteDroppedMin;
    @AutoSync
    public static int pasteDroppedMax;
    @AutoSync
    public static int t1ContainerCapacity;
    @AutoSync
    public static int t2ContainerCapacity;
    @AutoSync
    public static int t3ContainerCapacity;
    @AutoSync(mapperId="Pattern List Mapper")
    public static PatternList blockBlacklist;

    static void transferValues() {
        rayTraceRange = Config.rayTraceRange;
        poweredByFE = Config.poweredByFE;
        enableDestructionGadget = Config.enableDestructionGadget;
        absoluteCoordDefault = Config.absoluteCoordDefault;
        allowAbsoluteCoords = Config.allowAbsoluteCoords;
        canOverwriteBlocks = Config.canOverwriteBlocks;
        enablePaste = Config.enablePaste;
        pasteDroppedMin = Config.pasteDroppedMin;
        pasteDroppedMax = Config.pasteDroppedMax;
        blockBlacklist = FieldMapper.PATTERN_LIST_MAPPER.mapToField(Config.subCategoryBlacklist.blockBlacklist);
        maxRange = Config.subCategoryGadgets.maxRange;
        energyMax = Config.subCategoryGadgets.maxEnergy;
        energyCostBuilder = Config.subCategoryGadgets.subCategoryGadgetBuilding.energyCostBuilder;
        damageCostBuilder = Config.subCategoryGadgets.subCategoryGadgetBuilding.damageCostBuilder;
        durabilityBuilder = Config.subCategoryGadgets.subCategoryGadgetBuilding.durabilityBuilder;
        energyCostExchanger = Config.subCategoryGadgets.subCategoryGadgetExchanger.energyCostExchanger;
        damageCostExchanger = Config.subCategoryGadgets.subCategoryGadgetExchanger.damageCostExchanger;
        durabilityExchanger = Config.subCategoryGadgets.subCategoryGadgetExchanger.durabilityExchanger;
        energyMaxDestruction = Config.subCategoryGadgets.subCategoryGadgetDestruction.energyMaxDestruction;
        energyCostDestruction = Config.subCategoryGadgets.subCategoryGadgetDestruction.energyCostDestruction;
        damageCostDestruction = Config.subCategoryGadgets.subCategoryGadgetDestruction.damageCostDestruction;
        durabilityDestruction = Config.subCategoryGadgets.subCategoryGadgetDestruction.durabilityDestruction;
        nonFuzzyMultiplierDestruction = Config.subCategoryGadgets.subCategoryGadgetDestruction.nonFuzzyMultiplier;
        nonFuzzyEnabledDestruction = Config.subCategoryGadgets.subCategoryGadgetDestruction.nonFuzzyEnabled;
        energyCostCopyPaste = Config.subCategoryGadgets.subCategoryGadgetCopyPaste.energyCostCopyPaste;
        damageCostCopyPaste = Config.subCategoryGadgets.subCategoryGadgetCopyPaste.damageCostCopyPaste;
        durabilityCopyPaste = Config.subCategoryGadgets.subCategoryGadgetCopyPaste.durabilityCopyPaste;
        t1ContainerCapacity = Config.subCategoryPasteContainers.t1Capacity;
        t2ContainerCapacity = Config.subCategoryPasteContainers.t2Capacity;
        t3ContainerCapacity = Config.subCategoryPasteContainers.t3Capacity;
    }

    public static void sendConfigUpdateTo(EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncConfig(SyncedConfig.parseSynchronisation()), player);
        }
    }

    private static NBTTagCompound parseSynchronisation() {
        SyncedConfig.transferValues();
        NBTTagList list = new NBTTagList();
        List<Field> fields = Collections.unmodifiableList(SyncedConfig.getSyncFields());
        for (Field field : fields) {
            NBTTagCompound compound = SyncedConfig.parseField(field);
            if (compound == null) continue;
            list.func_74742_a((NBTBase)compound);
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(KEY_VALUE, (NBTBase)list);
        return compound;
    }

    public static void onReadSynchronisation(NBTTagCompound compound) {
        SyncedConfig.transferValues();
        if (!compound.func_74764_b(KEY_VALUE)) {
            return;
        }
        NBTTagList list = (NBTTagList)compound.func_74781_a(KEY_VALUE);
        List<Field> fields = SyncedConfig.getSyncFields();
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field f : fields) {
            map.put(SyncedConfig.getSyncName(f), f);
        }
        for (NBTBase rawNBT : list) {
            if (rawNBT instanceof NBTTagCompound) {
                SyncedConfig.handleNBT((NBTTagCompound)rawNBT, map);
                continue;
            }
            BuildingGadgets.logger.warn("Unexpected " + rawNBT.getClass().getName() + " found in NBTTagList which was expected to only contain NBTTagCompounds!");
        }
    }

    private static String getMapperIdFor(Field f) {
        return f.getAnnotation(AutoSync.class).mapperId();
    }

    private static NBTTagCompound parseField(Field field) {
        NBTBase valueTag = FieldSerializer.parseFieldValue(field, SyncedConfig.getMapperIdFor(field));
        if (valueTag == null) {
            BuildingGadgets.logger.warn("Could not use type of Field " + field.getName() + "! Found type " + field.getType().getName() + "!");
            return null;
        }
        String name = SyncedConfig.getSyncName(field);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(KEY_VALUE, valueTag);
        compound.func_74778_a(KEY_NAME, name);
        return compound;
    }

    private static void handleNBT(NBTTagCompound compound, Map<String, Field> fields) {
        if (!compound.func_74764_b(KEY_NAME) || !compound.func_74764_b(KEY_VALUE)) {
            BuildingGadgets.logger.warn("Tried to read synchronisation from an inproperly initialised NBTTagCompound!");
            return;
        }
        String name = compound.func_74779_i(KEY_NAME);
        NBTBase rawValue = compound.func_74781_a(KEY_VALUE);
        if (!fields.containsKey(name)) {
            BuildingGadgets.logger.warn("Tried to read synchronisation from an unknown Field!");
            return;
        }
        Field field = fields.get(name);
        FieldSerializer.applyValue(rawValue, field, SyncedConfig.getMapperIdFor(field));
    }

    private static List<Field> getSyncFields() {
        return ReflectionTool.getFilteredFields(SyncedConfig.class, field -> field.isAnnotationPresent(AutoSync.class) && ReflectionTool.PREDICATE_STATIC.test((Field)field));
    }

    private static String getSyncName(Field field) {
        String name = field.getAnnotation(AutoSync.class).value();
        return name.isEmpty() ? field.getName() : name;
    }

    static {
        SyncedConfig.transferValues();
    }
}

