/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.api.logic.pickable.PickableEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntryStack;
import ejektaflex.bountiful.config.BountifulIO;
import ejektaflex.bountiful.registry.BountyRegistry;
import ejektaflex.bountiful.registry.RewardRegistry;
import ejektaflex.bountiful.registry.ValueRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u009c\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\u000b*\u0002H\f\"\b\b\u0001\u0010\n*\u0002H\f\"\b\b\u0002\u0010\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u00120\u00112!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u0011H\u000b\u00a2\u0006\f\b\u0015\u0012\b\b\u0006\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u0002H\n0\u00142!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u0011H\n\u00a2\u0006\f\b\u0015\u0012\b\b\u0006\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00180\u0014H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\tJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\tJ$\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\r\u001a\u00020\u0007J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a8\u0006!"}, d2={"Lejektaflex/bountiful/config/BountifulIO;", "", "()V", "ensureDirectory", "Ljava/io/File;", "base", "name", "", "hotReload", "", "U", "T", "COMMON", "fileName", "registry", "Lejektaflex/bountiful/registry/ValueRegistry;", "fileContentType", "Ljava/lang/Class;", "", "transform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "it", "validity", "", "hotReloadBounties", "Lejektaflex/bountiful/api/logic/pickable/PickableEntry;", "hotReloadRewards", "Lejektaflex/bountiful/api/logic/picked/PickedEntryStack;", "populateConfigFolder", "folder", "defaultData", "safeHotReloadAll", "Bountiful"})
public final class BountifulIO {
    public static final BountifulIO INSTANCE;

    @NotNull
    public final File ensureDirectory(@NotNull File base, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        File newDir = new File(base, name);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        return newDir;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File populateConfigFolder(@NotNull File folder, @NotNull List<? extends Object> defaultData, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull(defaultData, (String)"defaultData");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File fileToPopulate = new File(folder, fileName);
        if (!fileToPopulate.exists()) {
            String content;
            void $receiver$iv;
            File file;
            File $receiver = file = fileToPopulate;
            $receiver.createNewFile();
            String string = "Going to serialize content..";
            System.out.println((Object)string);
            Collection collection = defaultData;
            Gson gson2 = gson;
            void thisCollection$iv = $receiver$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray2 = objectArray;
            String string2 = content = gson2.toJson((Object)objectArray2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"content");
            FilesKt.writeText$default((File)$receiver, (String)string2, null, (int)2, null);
        }
        return fileToPopulate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> safeHotReloadAll() {
        String string;
        Collection<String> collection;
        void $receiver$iv$iv;
        Object $receiver$iv;
        List list;
        Iterator iterator;
        Object it;
        Object invalids;
        Iterable<PickableEntry> iterable;
        List retMsg = new ArrayList();
        try {
            int numValidBounties;
            List oldBounties = BountyRegistry.INSTANCE.backup();
            iterable = this.hotReloadBounties();
            invalids = iterable;
            Collection collection2 = (Collection)invalids;
            if (!collection2.isEmpty()) {
                Iterable $receiver$iv2 = (Iterable)invalids;
                for (Object element$iv : $receiver$iv2) {
                    it = (PickableEntry)element$iv;
                    Collection collection3 = retMsg;
                    String string2 = "\u00a74Invalid bounty: " + ((PickableEntry)it).getContent() + ". Reverting to original data.";
                    collection3.add(string2);
                }
            }
            if ((numValidBounties = oldBounties.size() - invalids.size()) < Bountiful.INSTANCE.getConfig().getBountyAmountRange().getLast()) {
                Object element$iv;
                iterator = retMsg;
                element$iv = "\u00a74Your config file ('bounties.json') does not contain enough valid bounties.";
                iterator.add(element$iv);
                BountyRegistry.INSTANCE.restore(oldBounties);
            }
            iterable = retMsg;
            invalids = "Bounties Reloaded.";
            iterable.add((PickableEntry)invalids);
        }
        catch (Exception e) {
            iterable = retMsg;
            invalids = "\u00a74Invalid bounty json data. Details: ";
            iterable.add((PickableEntry)invalids);
            String string3 = e.getMessage();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            iterable = StringsKt.split$default((CharSequence)string3, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            list = retMsg;
            invalids = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                string = "\u00a74" + (String)it;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            list.addAll((Collection)collection);
        }
        try {
            Iterable $receiver$iv3 = this.hotReloadRewards();
            for (Object element$iv : $receiver$iv3) {
                Object item$iv$iv;
                PickedEntryStack it2 = (PickedEntryStack)element$iv;
                iterator = retMsg;
                item$iv$iv = "\u00a74Invalid reward: " + it2.getContent() + ". Skipping.";
                iterator.add(item$iv$iv);
            }
            $receiver$iv3 = retMsg;
            $receiver$iv = "Rewards Reloaded.";
            $receiver$iv3.add($receiver$iv);
        }
        catch (Exception e) {
            Object element$iv;
            $receiver$iv = retMsg;
            element$iv = "\u00a74Invalid reward json data. Details: ";
            $receiver$iv.add(element$iv);
            String string4 = e.getMessage();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = StringsKt.split$default((CharSequence)string4, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            list = retMsg;
            element$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String $i$a$3$forEach = (String)item$iv$iv;
                collection = destination$iv$iv;
                string = "\u00a74" + (String)it;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            list.addAll(collection);
        }
        return retMsg;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends COMMON, U extends COMMON, COMMON> List<U> hotReload(String fileName, ValueRegistry<U> registry, Class<T[]> fileContentType, Function1<? super T, ? extends U> transform, Function1<? super U, Boolean> validity) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable;
        try {
            Object object = new Gson().fromJson(FilesKt.readText$default((File)new File(Bountiful.INSTANCE.getConfigDir(), fileName), null, (int)1, null), fileContentType);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(\n       \u2026ContentType\n            )");
            iterable = ArraysKt.toList((Object[])((Object[])object));
        }
        catch (Exception e) {
            throw (Throwable)new Exception("JSON Structure of '" + fileName + "' is incorrect! Reverting to previous data. Details: " + e.getMessage());
        }
        List picked = iterable;
        iterable = CollectionsKt.filterNotNull((Iterable)picked);
        ValueRegistry<U> valueRegistry = registry;
        void e = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            destination$iv$iv.add(transform.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        return valueRegistry.replace(list, validity);
    }

    @NotNull
    public final List<PickableEntry> hotReloadBounties() {
        return this.hotReload("bounties.json", BountyRegistry.INSTANCE, PickableEntry[].class, hotReloadBounties.1.INSTANCE, hotReloadBounties.2.INSTANCE);
    }

    @NotNull
    public final List<PickedEntryStack> hotReloadRewards() {
        return this.hotReload("rewards.json", RewardRegistry.INSTANCE, PickedEntry[].class, hotReloadRewards.1.INSTANCE, hotReloadRewards.2.INSTANCE);
    }

    private BountifulIO() {
    }

    static {
        BountifulIO bountifulIO;
        INSTANCE = bountifulIO = new BountifulIO();
    }
}

