/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.baubleeffect;

import baubles.api.cap.BaublesCapabilities;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum EnumBaubleModifier {
    NONE("none", null, 0.0, 0, 5),
    HALF_HEARTED("half_hearted", SharedMonsterAttributes.field_111267_a, 1.0, 0, 3),
    HEARTY("hearty", SharedMonsterAttributes.field_111267_a, 2.0, 0, 1),
    HARD("hard", SharedMonsterAttributes.field_188791_g, 1.0, 0, 3),
    GUARDING("guarding", SharedMonsterAttributes.field_188791_g, 1.5, 0, 2),
    ARMORED("armored", SharedMonsterAttributes.field_188791_g, 2.0, 0, 1),
    WARDING("warding", SharedMonsterAttributes.field_189429_h, 1.0, 0, 2),
    JAGGED("jagged", SharedMonsterAttributes.field_111264_e, 0.02, 2, 2),
    SPIKED("spiked", SharedMonsterAttributes.field_111264_e, 0.04, 2, 2),
    ANGRY("angry", SharedMonsterAttributes.field_111264_e, 0.06, 2, 1),
    MENACING("menacing", SharedMonsterAttributes.field_111264_e, 0.08, 2, 1),
    BRISK("brisk", SharedMonsterAttributes.field_111263_d, 0.01, 2, 2),
    FLEETING("fleeting", SharedMonsterAttributes.field_111263_d, 0.02, 2, 2),
    HASTY("hasty", SharedMonsterAttributes.field_111263_d, 0.03, 2, 1),
    QUICK("quick", SharedMonsterAttributes.field_111263_d, 0.04, 2, 1),
    WILD("wild", SharedMonsterAttributes.field_188790_f, 0.02, 2, 2),
    RASH("rash", SharedMonsterAttributes.field_188790_f, 0.04, 2, 2),
    INTREPID("intrepid", SharedMonsterAttributes.field_188790_f, 0.06, 2, 1),
    VIOLENT("violent", SharedMonsterAttributes.field_188790_f, 0.08, 2, 1);

    public final String name;
    public final IAttribute attribute;
    public final double amount;
    public final int operation;
    public final int weight;
    public static final Set<IAttribute> attributes;
    private static final List<EnumBaubleModifier> VALUES;
    private static final int TOTAL_WEIGHT;
    private static final Random RANDOM;

    private EnumBaubleModifier(String name, IAttribute attribute, double amount, int operation, int weight) {
        this.name = name;
        this.attribute = attribute;
        this.amount = amount;
        this.operation = operation;
        this.weight = weight;
    }

    private static final int getTotalWeight() {
        int total = 0;
        for (EnumBaubleModifier mod : VALUES) {
            total += mod.weight;
        }
        return total;
    }

    public static EnumBaubleModifier getWeightedRandom() {
        int rand = RANDOM.nextInt(TOTAL_WEIGHT);
        int currentWeight = 0;
        for (EnumBaubleModifier mod : VALUES) {
            if (rand >= (currentWeight += mod.weight)) continue;
            return mod;
        }
        return NONE;
    }

    public static void generateModifier(ItemStack stack) {
        if (!stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            return;
        }
        if (stack.func_77976_d() > 1) {
            return;
        }
        EnumBaubleModifier.getWeightedRandom().addTo(stack);
    }

    public void addTo(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("baubleModifier", this.name);
    }

    public static EnumBaubleModifier get(String str) {
        try {
            return EnumBaubleModifier.valueOf(str.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        attributes = new HashSet<IAttribute>();
        for (EnumBaubleModifier mod : EnumBaubleModifier.values()) {
            if (mod.attribute == null) continue;
            attributes.add(mod.attribute);
        }
        VALUES = Collections.unmodifiableList(Arrays.asList(EnumBaubleModifier.values()));
        TOTAL_WEIGHT = EnumBaubleModifier.getTotalWeight();
        RANDOM = new Random();
    }
}

