/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;

public class TileCorporeaCrystalCube
extends TileCorporeaBase
implements ICorporeaRequestor,
ITickable {
    private static final String TAG_REQUEST_TARGET = "requestTarget";
    private static final String TAG_ITEM_COUNT = "itemCount";
    private static final String TAG_LOCK = "lock";
    private ItemStack requestTarget = ItemStack.field_190927_a;
    private int itemCount = 0;
    private int ticks = 0;
    private int compValue = 0;
    public boolean locked = false;
    private final IAnimationStateMachine asm = FMLCommonHandler.instance().getSide() == Side.CLIENT ? ModelLoaderRegistry.loadASM((ResourceLocation)new ResourceLocation("botania", "asms/block/corporeacrystalcube.json"), (ImmutableMap)ImmutableMap.of()) : null;

    public void func_73660_a() {
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            this.updateCount();
        }
    }

    public void setRequestTarget(ItemStack stack) {
        if (!stack.func_190926_b() && !this.locked) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            this.requestTarget = copy;
            this.updateCount();
            if (!this.field_145850_b.field_72995_K) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }

    public ItemStack getRequestTarget() {
        return this.requestTarget;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void doRequest(boolean fullStack) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ICorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && this.requestTarget != null) {
            int count = fullStack ? this.requestTarget.func_77976_d() : 1;
            this.doCorporeaRequest(this.requestTarget, count, spark);
        }
    }

    private void updateCount() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int oldCount = this.itemCount;
        this.itemCount = 0;
        ICorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && this.requestTarget != null) {
            List<ItemStack> stacks = CorporeaHelper.requestItem(this.requestTarget, -1, spark, true, false);
            for (ItemStack stack : stacks) {
                this.itemCount += stack.func_190916_E();
            }
        }
        if (this.itemCount != oldCount) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.onUpdateCount();
        }
    }

    private void onUpdateCount() {
        int oldCompValue = this.compValue;
        this.compValue = CorporeaHelper.signalStrengthForRequestSize(this.itemCount);
        if (this.compValue != oldCompValue) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        }
    }

    @Override
    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        NBTTagCompound cmp = new NBTTagCompound();
        if (!this.requestTarget.func_190926_b()) {
            cmp = this.requestTarget.func_77955_b(cmp);
        }
        par1nbtTagCompound.func_74782_a(TAG_REQUEST_TARGET, (NBTBase)cmp);
        par1nbtTagCompound.func_74768_a(TAG_ITEM_COUNT, this.itemCount);
        par1nbtTagCompound.func_74757_a(TAG_LOCK, this.locked);
    }

    @Override
    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        NBTTagCompound cmp = par1nbtTagCompound.func_74775_l(TAG_REQUEST_TARGET);
        this.requestTarget = new ItemStack(cmp);
        this.itemCount = par1nbtTagCompound.func_74762_e(TAG_ITEM_COUNT);
        this.locked = par1nbtTagCompound.func_74767_n(TAG_LOCK);
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    @Override
    public void doCorporeaRequest(Object request, int count, ICorporeaSpark spark) {
        if (!(request instanceof ItemStack)) {
            return;
        }
        List<ItemStack> stacks = CorporeaHelper.requestItem(request, count, spark, true, true);
        spark.onItemsRequested(stacks);
        boolean did = false;
        for (ItemStack reqStack : stacks) {
            if (this.requestTarget == null) continue;
            EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, reqStack);
            this.field_145850_b.func_72838_d((Entity)item);
            this.itemCount -= reqStack.func_190916_E();
            did = true;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.onUpdateCount();
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityAnimation.ANIMATION_CAPABILITY || super.hasCapability(cap, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return super.getCapability(cap, side);
    }
}

