/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.brewery;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.integration.jei.brewery.BreweryRecipeWrapper;

public class BreweryRecipeCategory
implements IRecipeCategory<BreweryRecipeWrapper> {
    public static final String UID = "botania.brewery";
    private final IDrawableStatic background;
    private final String localizedName;

    public BreweryRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("botania", "textures/gui/neiBrewery.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 166, 65);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.brewery", (Object[])new Object[0]);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public String getModName() {
        return "Botania";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull BreweryRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        IFocus focus = recipeLayout.getFocus();
        recipeLayout.getItemStacks().init(0, true, 39, 41);
        recipeLayout.getItemStacks().set(0, this.getItemMatchingFocus(focus, IFocus.Mode.OUTPUT, (List)outputs.get(0), (List)inputs.get(0)));
        int index = 1;
        int posX = 60;
        for (int i = 1; i < inputs.size(); ++i) {
            List o = (List)inputs.get(i);
            recipeLayout.getItemStacks().init(index, true, posX, 6);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            posX += 18;
        }
        recipeLayout.getItemStacks().init(7, false, 87, 41);
        recipeLayout.getItemStacks().set(7, this.getItemMatchingFocus(focus, IFocus.Mode.INPUT, (List)inputs.get(0), (List)outputs.get(0)));
    }

    private List<ItemStack> getItemMatchingFocus(IFocus<?> focus, IFocus.Mode mode, List<ItemStack> focused, List<ItemStack> other) {
        if (focus != null && focus.getMode() == mode) {
            ItemStack focusStack = (ItemStack)focus.getValue();
            for (int i = 0; i < focused.size(); ++i) {
                if (!focusStack.func_77969_a(focused.get(i))) continue;
                return Collections.singletonList(other.get(i));
            }
        }
        return other;
    }
}

