/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.item.ItemBindableBase;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemLavaCrystal
extends ItemBindableBase
implements IVariantProvider {
    public ItemLavaCrystal() {
        this.func_77655_b("bloodmagic.lavaCrystal");
    }

    public ItemStack getContainerItem(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            NetworkHelper.getSoulNetwork(binding.getOwnerId()).syphon(SoulTicket.item(stack, 25));
        }
        ItemStack returnStack = new ItemStack((Item)this);
        returnStack.func_77982_d(stack.func_77978_p());
        return returnStack;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public int getItemBurnTime(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return -1;
        }
        if (NetworkHelper.syphonFromContainer(stack, SoulTicket.item(stack, 25))) {
            return 200;
        }
        EntityPlayer player = PlayerHelper.getPlayerFromUUID(binding.getOwnerId());
        if (player != null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 99));
        }
        return -1;
    }

    @Override
    @Nullable
    public Binding getBinding(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return null;
        }
        NBTBase bindingTag = stack.func_77978_p().func_74781_a("binding");
        if (bindingTag == null || bindingTag.func_74732_a() != 10 || bindingTag.func_82582_d()) {
            return null;
        }
        NBTTagCompound nbt = (NBTTagCompound)bindingTag;
        return new Binding(NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l("id")), nbt.func_74779_i("name"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        pos = pos.func_177972_a(facing);
        ItemStack itemstack = player.func_184586_b(hand);
        Binding binding = this.getBinding(player.func_184586_b(hand));
        if (binding == null) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.func_175623_d(pos) || !NetworkHelper.getSoulNetwork(binding).syphonAndDamage(player, SoulTicket.item(player.func_184586_b(hand), 100)).isSuccess()) {
            return EnumActionResult.FAIL;
        }
        worldIn.func_184133_a(player, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
        worldIn.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, itemstack);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=normal");
    }
}

