/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.biomestaff.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import p455w0rd.biomestaff.init.ModItems;

public class BiomeStaffUtil {
    public static Biome getBiomeFromStaff(ItemStack staff) {
        Biome biome;
        if (staff.func_77942_o() && staff.func_77978_p().func_150297_b("biome", 1) && (biome = Biome.func_150568_d((int)(staff.func_77978_p().func_74771_c("biome") & 0xFF))) != null) {
            return biome;
        }
        return null;
    }

    public static boolean doesStaffContainBiome(ItemStack staff) {
        return BiomeStaffUtil.getBiomeFromStaff(staff) != null;
    }

    public static IBlockState getBiomeTopBlockFromStaff(ItemStack staff) {
        Biome biome;
        ResourceLocation regName;
        IBlockState returnBlock = Blocks.field_150350_a.func_176223_P();
        if (BiomeStaffUtil.doesStaffContainBiome(staff) && (regName = (biome = BiomeStaffUtil.getBiomeFromStaff(staff)).getRegistryName()).func_110624_b().equals("minecraft")) {
            String path = regName.func_110623_a();
            returnBlock = path.equals("hell") ? Blocks.field_150424_aL.func_176223_P() : (path.equals("mushroom_island") || path.equals("mushroom_island_shore") ? Blocks.field_150337_Q.func_176223_P() : (path.equals("birch_forest") || path.equals("birch_forest_hills") || path.equals("mutated_birch_forest") || path.equals("mutated_birch_forest_hills") ? Blocks.field_150364_r.func_176203_a(2) : biome.field_76752_A));
        }
        return returnBlock;
    }

    public static ItemStack getItemTopBlockStack(ItemStack staff) {
        IBlockState biomeTopBlockState = BiomeStaffUtil.getBiomeTopBlockFromStaff(staff);
        if (biomeTopBlockState != null) {
            return biomeTopBlockState.func_177230_c().getPickBlock(biomeTopBlockState, null, null, null, null);
        }
        return ItemStack.field_190927_a;
    }

    public static NonNullList<ItemStack> getAllBiomeStaffs() {
        NonNullList staffList = NonNullList.func_191196_a();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            staffList.add((Object)BiomeStaffUtil.getStaffForBiome(biome));
        }
        return staffList;
    }

    public static ItemStack getStaffForBiome(Biome biome) {
        ItemStack staff = new ItemStack((Item)ModItems.BIOME_STAFF);
        staff.func_77982_d(BiomeStaffUtil.createTagForBiome(biome));
        return staff;
    }

    public static NBTTagCompound createTagForBiome(Biome biome) {
        NBTTagCompound tag = new NBTTagCompound();
        byte biomeId = (byte)Biome.func_185362_a((Biome)biome);
        tag.func_74774_a("biome", biomeId);
        return tag;
    }
}

