/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.biomestaff.item;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.biomestaff.client.model.IModelProvider;
import p455w0rd.biomestaff.init.ModCreativeTab;
import p455w0rd.biomestaff.init.ModNetworking;
import p455w0rd.biomestaff.network.PacketSyncBiomeStaff;
import p455w0rd.biomestaff.network.PacketUpdateChunkRender;
import p455w0rd.biomestaff.util.BiomeStaffUtil;

public class ItemBiomeStaff
extends Item
implements IModelProvider {
    public static final String TAG_BIOME = "biome";
    private static final ResourceLocation REGISTRY_NAME = new ResourceLocation("biomestaff", "biome_staff");

    public ItemBiomeStaff() {
        this.func_77655_b(REGISTRY_NAME.toString());
        this.setRegistryName(REGISTRY_NAME);
        this.func_77627_a(true);
        this.func_77637_a(ModCreativeTab.MAIN_TAB);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            items.addAll(BiomeStaffUtil.getAllBiomeStaffs());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        NBTTagCompound nbt;
        ItemStack heldStack;
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND && player.func_70093_af() && (heldStack = player.func_184614_ca()).func_77942_o() && (nbt = heldStack.func_77978_p()).func_150297_b(TAG_BIOME, 1)) {
            nbt.func_82580_o(TAG_BIOME);
            ModNetworking.getInstance().sendTo((IMessage)new PacketSyncBiomeStaff(nbt), (EntityPlayerMP)player);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldStack = player.func_184614_ca();
        if (!heldStack.func_77942_o()) {
            heldStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = heldStack.func_77978_p();
        int size = 7;
        int rad = size / 2;
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND && !heldStack.func_190926_b()) {
            if (player.func_70093_af()) {
                Chunk chunk = world.func_175726_f(pos);
                int relBlockX = pos.func_177958_n() & 0xF;
                int relBlockZ = pos.func_177952_p() & 0xF;
                byte biomeType = chunk.func_76605_m()[relBlockZ << 4 | relBlockX];
                if (!tag.func_150297_b(TAG_BIOME, 1) || tag.func_150297_b(TAG_BIOME, 1) && tag.func_74771_c(TAG_BIOME) != biomeType) {
                    tag.func_74774_a(TAG_BIOME, biomeType);
                    heldStack.func_77982_d(tag);
                    ModNetworking.getInstance().sendTo((IMessage)new PacketSyncBiomeStaff(heldStack.func_77978_p()), (EntityPlayerMP)player);
                }
            } else if (tag.func_74764_b(TAG_BIOME)) {
                byte biome = tag.func_74771_c(TAG_BIOME);
                for (int ix = pos.func_177958_n() - rad; ix <= pos.func_177958_n() + rad; ++ix) {
                    for (int iz = pos.func_177952_p() - rad; iz <= pos.func_177952_p() + rad; ++iz) {
                        int relBlockX = ix & 0xF;
                        int relBlockZ = iz & 0xF;
                        Chunk chunk = world.func_175726_f(new BlockPos(ix, pos.func_177956_o(), iz));
                        byte[] byteArray = chunk.func_76605_m();
                        byte currentByte = byteArray[relBlockZ << 4 | relBlockX];
                        if (currentByte == biome) continue;
                        byteArray[relBlockZ << 4 | relBlockX] = biome;
                        chunk.func_76616_a(byteArray);
                        chunk.func_177427_f(true);
                    }
                }
                ModNetworking.getInstance().sendTo((IMessage)new PacketUpdateChunkRender(pos, rad, biome), (EntityPlayerMP)player);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String biomeName = "";
        Biome biome = BiomeStaffUtil.getBiomeFromStaff(stack);
        if (biome != null && (biomeName = biome.func_185359_l()) != null && !biomeName.isEmpty()) {
            biomeName = " - " + biomeName;
        }
        return I18n.func_74838_a((String)(stack.func_77973_b().func_77658_a() + ".name")).trim() + "" + biomeName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(REGISTRY_NAME, "inventory"));
    }
}

