/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntityArmorStand
extends BiblioTileEntity {
    public boolean helm = false;
    public boolean cuirass = false;
    public boolean greaves = false;
    public boolean boots = false;
    public int showArmorText = 0;
    private boolean isBottomStand = true;

    public TileEntityArmorStand() {
        super(4, true);
    }

    public void setIsBottomStand(boolean isBottom) {
        this.isBottomStand = isBottom;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public boolean getIsBottomStand() {
        return this.isBottomStand;
    }

    public void checkArmorSlots() {
        ItemStack stackTest0 = this.func_70301_a(0);
        this.helm = stackTest0 != ItemStack.field_190927_a;
        ItemStack stackTest1 = this.func_70301_a(1);
        this.cuirass = stackTest1 != ItemStack.field_190927_a;
        ItemStack stackTest2 = this.func_70301_a(2);
        this.greaves = stackTest2 != ItemStack.field_190927_a;
        ItemStack stackTest3 = this.func_70301_a(3);
        this.boots = stackTest3 != ItemStack.field_190927_a;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public boolean getHelm() {
        return this.helm;
    }

    public boolean getCuirass() {
        return this.cuirass;
    }

    public boolean getGreaves() {
        return this.greaves;
    }

    public boolean getBoots() {
        return this.boots;
    }

    public boolean addArmor(ItemStack stack, EntityEquipmentSlot armorType) {
        this.checkArmorSlots();
        switch (armorType) {
            case HEAD: {
                if (this.helm) break;
                this.func_70299_a(0, stack);
                return true;
            }
            case CHEST: {
                if (this.cuirass) break;
                this.func_70299_a(1, stack);
                return true;
            }
            case LEGS: {
                if (this.greaves) break;
                this.func_70299_a(2, stack);
                return true;
            }
            case FEET: {
                if (this.boots) break;
                this.func_70299_a(3, stack);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        ItemArmor armorItem;
        if (!this.getIsBottomStand()) {
            return false;
        }
        Item stackItem = itemstack.func_77973_b();
        if (stackItem instanceof ItemArmor && (armorItem = (ItemArmor)stackItem) != ItemStack.field_190927_a.func_77973_b()) {
            EntityEquipmentSlot armorType = armorItem.field_77881_a;
            if (slot == 0 && armorType == EntityEquipmentSlot.FEET) {
                return true;
            }
            if (slot == 1 && armorType == EntityEquipmentSlot.LEGS) {
                return true;
            }
            if (slot == 2 && armorType == EntityEquipmentSlot.CHEST) {
                return true;
            }
            return slot == 3 && armorType == EntityEquipmentSlot.HEAD;
        }
        return false;
    }

    public String func_70005_c_() {
        return "ArmorStand";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
        this.checkArmorSlots();
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.helm = nbt.func_74767_n("helm");
        this.cuirass = nbt.func_74767_n("cuirass");
        this.greaves = nbt.func_74767_n("greaves");
        this.boots = nbt.func_74767_n("boots");
        this.isBottomStand = nbt.func_74767_n("isBottom");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74757_a("helm", this.helm);
        nbt.func_74757_a("cuirass", this.cuirass);
        nbt.func_74757_a("greaves", this.greaves);
        nbt.func_74757_a("boots", this.boots);
        nbt.func_74757_a("isBottom", this.isBottomStand);
        return nbt;
    }

    public ITextComponent func_145748_c_() {
        TextComponentString chat = new TextComponentString(this.func_70005_c_());
        return chat;
    }
}

