/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.anubis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.entity.stone.EntityStoneBase;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.utils.StackHelper;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="atum")
public class ItemAnubisWrath
extends ItemSword {
    private static final TObjectFloatMap<EntityPlayer> cooldown = new TObjectFloatHashMap();

    public ItemAnubisWrath() {
        super(Item.ToolMaterial.DIAMOND);
        this.func_185043_a(new ResourceLocation("tier"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ItemAnubisWrath.getTier(stack);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public EnumRarity func_77613_e(@Nonnull ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return !Keyboard.isKeyDown((int)42) ? super.showDurabilityBar(stack) : ItemAnubisWrath.getSouls(stack) > 0;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return !Keyboard.isKeyDown((int)42) ? super.getDurabilityForDisplay(stack) : (double)(ItemAnubisWrath.getSoulUpgradeTier(ItemAnubisWrath.getTier(stack)) - Math.min(ItemAnubisWrath.getSouls(stack), 500)) / (double)ItemAnubisWrath.getSoulUpgradeTier(ItemAnubisWrath.getTier(stack));
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return !Keyboard.isKeyDown((int)42) ? super.getRGBDurabilityForDisplay(stack) : 12452784;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_184614_ca().func_77973_b() == AtumItems.ANUBIS_WRATH && ItemAnubisWrath.getTier(player.func_184614_ca()) == 3 && event.getTarget() instanceof EntityLivingBase && ((EntityLivingBase)event.getTarget()).func_70668_bt() != EnumCreatureAttribute.UNDEAD && !(event.getTarget() instanceof EntityStoneBase)) {
            cooldown.put((Object)player, player.func_184825_o(0.5f));
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof EntityPlayer && cooldown.containsKey((Object)trueSource)) {
            if (cooldown.get((Object)trueSource) == 1.0f) {
                event.setAmount(event.getAmount() * 2.0f);
                EntityLivingBase entity = event.getEntityLiving();
                double y = MathHelper.func_82716_a((Random)field_77697_d, (double)0.02, (double)0.13);
                for (int l = 0; l < 5; ++l) {
                    Atum.proxy.spawnParticle(AtumParticles.Types.ANUBIS, (Entity)entity, entity.field_70165_t + (field_77697_d.nextDouble() - 0.5) * (double)entity.field_70130_N, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v + (field_77697_d.nextDouble() - 0.5) * (double)entity.field_70130_N, 0.0, y, 0.0);
                }
            }
            cooldown.remove((Object)trueSource);
        }
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        EntityPlayer player;
        InventoryPlayer inv;
        Entity source = event.getSource().func_76346_g();
        if (source instanceof EntityLivingBase && ((EntityLivingBase)source).func_184614_ca().func_77973_b() == AtumItems.ANUBIS_WRATH) {
            ItemStack heldStack = ((EntityLivingBase)source).func_184614_ca();
            NBTTagCompound tag = StackHelper.getTag(heldStack);
            tag.func_74768_a("souls", ItemAnubisWrath.getSouls(heldStack) + 1);
            if (ItemAnubisWrath.getSouls(heldStack) == 50 || ItemAnubisWrath.getSouls(heldStack) == 150 || ItemAnubisWrath.getSouls(heldStack) == 500) {
                source.field_70170_p.func_184133_a(null, source.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 0.0f);
                if (source instanceof EntityPlayer) {
                    ((EntityPlayer)source).func_146105_b(new TextComponentTranslation(heldStack.func_77977_a() + ".levelup", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer && (inv = player.field_71071_by).func_70431_c(ItemAnubisWrath.findAnubisWrath(player = (EntityPlayer)event.getEntityLiving()))) {
            NBTTagCompound tag = StackHelper.getTag(ItemAnubisWrath.findAnubisWrath(player));
            tag.func_74768_a("souls", ItemAnubisWrath.getSouls(ItemAnubisWrath.findAnubisWrath(player)) / 2);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187553_bI, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Nonnull
    private static ItemStack findAnubisWrath(EntityPlayer player) {
        if (player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == AtumItems.ANUBIS_WRATH) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == AtumItems.ANUBIS_WRATH) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != AtumItems.ANUBIS_WRATH) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            int tier = ItemAnubisWrath.getTier(stack);
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", tier == 3 ? 9.0 : (double)tier + 5.0, 0));
            double speed = tier == 0 ? 0.6 : (tier == 1 ? 0.7 : (tier == 2 ? 0.8 : (tier == 3 ? 1.0 : 0.0)));
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", speed - 3.0, 0));
        }
        return map;
    }

    private static int getSouls(@Nonnull ItemStack stack) {
        return StackHelper.hasKey(stack, "souls") ? Objects.requireNonNull(stack.func_77978_p()).func_74762_e("souls") : 0;
    }

    private static int getTier(@Nonnull ItemStack stack) {
        int souls = ItemAnubisWrath.getSouls(stack);
        return souls < 50 ? 0 : (souls < 150 ? 1 : (souls < 500 ? 2 : 3));
    }

    private static int getSoulUpgradeTier(int tier) {
        return tier == 0 ? 50 : (tier == 1 ? 150 : (tier == 2 ? 500 : 500));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipType) {
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)(this.func_77658_a() + ".line1" + (ItemAnubisWrath.getTier(stack) == 3 ? ".soulUnraveler" : ".soulDrinker")), (Object[])new Object[0]));
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)(this.func_77658_a() + ".line2" + (ItemAnubisWrath.getTier(stack) == 3 ? ".soulUnraveler" : ".soulDrinker")), (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + (ItemAnubisWrath.getTier(stack) == 3 ? ".soulUnraveler" : ".soulDrinker")), (Object[])new Object[0]) + " " + TextFormatting.DARK_GRAY + "[SHIFT]");
        }
        if (tooltipType.func_194127_a()) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)(this.func_77658_a() + ".kills"), (Object[])new Object[]{ItemAnubisWrath.getSouls(stack)}));
        }
    }
}

