/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines.tileentity;

import com.teammetallurgy.atum.api.recipe.RecipeHandlers;
import com.teammetallurgy.atum.api.recipe.spinningwheel.ISpinningWheelRecipe;
import com.teammetallurgy.atum.blocks.base.tileentity.TileEntityInventoryBase;
import com.teammetallurgy.atum.blocks.machines.BlockSpinningWheel;
import com.teammetallurgy.atum.utils.StackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntitySpinningWheel
extends TileEntityInventoryBase
implements ISidedInventory {
    public NBTTagCompound input = new NBTTagCompound();
    public boolean wheel;
    public int rotations;
    private IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);

    public TileEntitySpinningWheel() {
        super(2);
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        for (ISpinningWheelRecipe spinningWheelRecipe : RecipeHandlers.spinningWheelRecipes.getValuesCollection()) {
            for (ItemStack input : spinningWheelRecipe.getInput()) {
                if (!ItemStack.func_179545_c((ItemStack)input, (ItemStack)stack)) continue;
                return spinningWheelRecipe.isValidInput(stack);
            }
        }
        return false;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        this.func_145839_a(packet.func_148857_g());
        this.func_70296_d();
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        if (side != EnumFacing.UP) {
            return new int[]{0};
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing facing) {
        int spool = (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSpinningWheel.SPOOL);
        if (this.func_70301_a(0).func_190926_b() && this.func_70301_a(1).func_190926_b() && index == 0 && this.func_94041_b(0, stack) && spool < 3 && (this.input.func_82582_d() || StackHelper.areStacksEqualIgnoreSize(new ItemStack(this.input), stack))) {
            if (this.input.func_82582_d()) {
                this.input = stack.func_77955_b(new NBTTagCompound());
            }
            return true;
        }
        return false;
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        BlockSpinningWheel spinningWheel = (BlockSpinningWheel)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (index == 1 && direction == EnumFacing.DOWN) {
            spinningWheel.output(this.field_145850_b, this.field_174879_c, null, this);
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            return (T)this.handlerSide;
        }
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != EnumFacing.UP && super.hasCapability(capability, facing);
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer player) {
        return null;
    }

    @Nonnull
    public String func_174875_k() {
        return "";
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.wheel = compound.func_74767_n("wheel");
        this.rotations = compound.func_74762_e("rotations");
        this.input = compound.func_74775_l("input");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("wheel", this.wheel);
        compound.func_74768_a("rotations", this.rotations);
        if (this.input != null) {
            compound.func_74782_a("input", (NBTBase)this.input);
        }
        return compound;
    }
}

