/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.glass;

import com.google.common.base.Preconditions;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockPane;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

public class BlockAtumStainedGlassPane
extends BlockPane
implements IOreDictEntry {
    private BlockAtumStainedGlassPane() {
        super(Material.field_151592_s, false);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public static void registerStainedGlassPane(Block glassBlock) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            Preconditions.checkNotNull((Object)glassBlock.getRegistryName(), (Object)"registryName");
            AtumRegistry.registerBlock((Block)new BlockAtumStainedGlassPane(), glassBlock.getRegistryName().func_110623_a().replace("_glass", "") + "_" + color.func_176610_l() + "_stained_glass");
        }
    }

    public static Block getGlass(Block baseGlassBlack, EnumDyeColor color) {
        Preconditions.checkNotNull((Object)baseGlassBlack.getRegistryName(), (Object)"registryName");
        return (Block)field_149771_c.func_82594_a((Object)new ResourceLocation("atum", "thin_" + baseGlassBlack.getRegistryName().func_110623_a().replace("_glass", "") + "_" + color.func_176610_l() + "_stained_glass"));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return EnumDyeColor.valueOf((String)WordUtils.swapCase((String)this.getColorString())).func_193349_f();
    }

    private String getColorString() {
        Preconditions.checkNotNull((Object)this.getRegistryName(), (Object)"registryName");
        return this.getRegistryName().func_110623_a().replace("thin_", "").replace("framed_", "").replace("crystal_", "").replace("_stained", "").replace("_glass", "");
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            BlockBeacon.func_176450_d((World)world, (BlockPos)pos);
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!world.field_72995_K) {
            BlockBeacon.func_176450_d((World)world, (BlockPos)pos);
        }
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add((Block)this, "paneGlass", this.getColorString().replace("silver", "light_gray"));
        OreDictHelper.add((Block)this, "paneGlass");
    }
}

