/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.beacon;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.beacon.tileentity.TileEntityRadiantBeacon;
import com.teammetallurgy.atum.blocks.glass.BlockAtumStainedGlass;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRadiantBeacon
extends BlockBeacon {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    private static final HashMap<Integer, EnumDyeColor> RGB_TO_DYE = Maps.newHashMap();

    public BlockRadiantBeacon() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE));
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileEntityRadiantBeacon();
    }

    @Nonnull
    public Material func_149688_o(IBlockState state) {
        return Material.field_151592_s;
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b(COLOR)));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public boolean func_180639_a(World world, @Nonnull BlockPos pos, IBlockState state, @Nonnull EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_190926_b()) {
            return false;
        }
        Item item = heldStack.func_77973_b();
        if (!world.field_72995_K) {
            if (item == Item.func_150898_a((Block)Blocks.field_150399_cn) || item == Item.func_150898_a((Block)Blocks.field_150397_co)) {
                world.func_180501_a(pos, AtumBlocks.RADIANT_BEACON.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)heldStack.func_77960_j())), 2);
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
            } else {
                float[] color = Block.func_149634_a((Item)item).getBeaconColorMultiplier(state, world, pos, pos);
                if (color != null) {
                    int r = (int)(color[0] * 255.0f);
                    int g = (int)(color[1] * 255.0f);
                    int b = (int)(color[2] * 255.0f);
                    int rgb = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                    EnumDyeColor dyeColor = RGB_TO_DYE.get(rgb);
                    Block block = AtumBlocks.RADIANT_BEACON;
                    if (Block.func_149634_a((Item)item) == BlockAtumStainedGlass.getGlass(AtumBlocks.FRAMED_GLASS, dyeColor) || Block.func_149634_a((Item)item) == BlockAtumStainedGlass.getGlass(AtumBlocks.THIN_FRAMED_GLASS, dyeColor)) {
                        block = AtumBlocks.RADIANT_BEACON_FRAMED;
                    }
                    world.func_175656_a(pos, block.func_176223_P().func_177226_a(COLOR, (Comparable)dyeColor));
                    if (!player.func_184812_l_()) {
                        heldStack.func_190918_g(1);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    static {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            for (EnumDyeColor color : EnumDyeColor.values()) {
                RGB_TO_DYE.put(color.func_193350_e(), color);
            }
        }
    }
}

