/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.google.common.collect.ImmutableMap;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.entity.living.EntityEvilClassWizard;
import com.windanesz.ancientspellcraft.integration.antiqueatlas.ASAntiqueAtlasIntegration;
import com.windanesz.ancientspellcraft.worldgen.WorldGenSurfaceStructureAS;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class WorldGenBattlemageCamp
extends WorldGenSurfaceStructureAS {
    private static final String WIZARD_DATA_BLOCK_TAG = "wizard";
    private static final String EVIL_WIZARD_DATA_BLOCK_TAG = "evil_wizard";
    private final Map<BiomeDictionary.Type, IBlockState> specialWallBlocks = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_180395_cM.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150417_aV.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150385_bj.func_176223_P(), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150322_A.func_176223_P());

    public String getStructureName() {
        return "battlemage_camp";
    }

    public long getRandomSeedModifier() {
        return 98416541L;
    }

    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Settings.worldgenSettings.battlemageCampDimensions, (int)world.field_73011_w.getDimension()) && Settings.worldgenSettings.battlemageCampRarity > 0 && random.nextInt(Settings.worldgenSettings.battlemageCampRarity) == 0;
    }

    public ResourceLocation getStructureFile(Random random) {
        return AncientSpellcraft.settings.battlemageCampWithChestFiles[0];
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        EnumDyeColor colour = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        Biome biome = world.func_180494_b(origin);
        IBlockState wallMaterial = this.specialWallBlocks.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.specialWallBlocks::get).orElse(Blocks.field_150347_e.func_176223_P());
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        HashSet blocksPlaced = new HashSet();
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150325_L ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150325_L.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150404_cg ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150404_cg.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_180394_cL ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150404_cg.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150347_e ? new Template.BlockInfo(i.field_186242_a, wallMaterial, i.field_186244_c) : i, new WoodTypeTemplateProcessor(woodType)});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
        ASAntiqueAtlasIntegration.markBattlemageCamp(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            Object wizard;
            Vec3d vec = GeometryUtils.getCentre((BlockPos)((BlockPos)entry.getKey()));
            if (((String)entry.getValue()).equals(WIZARD_DATA_BLOCK_TAG)) {
                wizard = new EntityWizard(world);
                wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
                wizard.func_180482_a(world.func_175649_E(origin), null);
                wizard.setTowerBlocks(blocksPlaced);
                world.func_72838_d((Entity)wizard);
                continue;
            }
            if (((String)entry.getValue()).equals(EVIL_WIZARD_DATA_BLOCK_TAG)) {
                wizard = new EntityEvilClassWizard(world);
                wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
                ((EntityEvilClassWizard)wizard).hasStructure = true;
                ((EntityEvilClassWizard)wizard).func_180482_a(world.func_175649_E(origin), null);
                world.func_72838_d((Entity)wizard);
                continue;
            }
            Wizardry.logger.info("Unrecognised data block value {} in structure {}", entry.getValue(), (Object)structureFile);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP && event.player.field_70173_aa % 20 == 0) {
            WizardryAdvancementTriggers.visit_structure.trigger((EntityPlayerMP)event.player);
        }
    }
}

