/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.registry.Rituals;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public final class RitualProperties {
    private static final Gson gson = new Gson();
    public final int lifetime;
    public final int size;
    public int centerPieceIndex;
    public Item centerpiece;
    public int width = 0;
    public int height = 0;
    public NonNullList<Ingredient> pattern;
    public Ingredient centerPiece;

    private RitualProperties(JsonObject json, Ritual ritual) {
        this.lifetime = JsonUtils.func_151203_m((JsonObject)json, (String)"lifetime");
        this.size = JsonUtils.func_151203_m((JsonObject)json, (String)"size");
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)new JsonContext("ancientspellcraft")));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line;
            pattern[x] = line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            this.width = line.length();
        }
        this.height = patternJ.size();
        this.pattern = NonNullList.func_191197_a((int)(pattern[0].length() * pattern.length), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                this.pattern.set(x++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        this.centerPieceIndex = (int)Math.ceil(this.pattern.size() / 2);
        Ingredient test = (Ingredient)this.pattern.get(this.centerPieceIndex);
        this.centerpiece = ((Ingredient)this.pattern.get(this.centerPieceIndex)).func_193365_a().length > 0 ? ((Ingredient)this.pattern.get(this.centerPieceIndex)).func_193365_a()[0].func_77973_b() : null;
    }

    public static void init() {
        Set modIDs = Ritual.getAllRituals().stream().map(s -> s.getRegistryName().func_110624_b()).collect(Collectors.toSet());
        boolean flag = RitualProperties.loadConfigRitualProperties();
        for (String modID : modIDs) {
            flag &= RitualProperties.loadBuiltInRitualProperties(modID);
        }
        if (!flag) {
            AncientSpellcraft.logger.warn("Some ritual property files did not load correctly; this will likely cause problems later!");
        }
    }

    public static void loadWorldSpecificSpellProperties(World world) {
        AncientSpellcraft.logger.info("Loading custom ritual properties for world {}", (Object)world.func_72912_H().func_76065_j());
        File spellJSONDir = new File(new File(world.func_72860_G().func_75765_b(), "data"), "rituals");
        if (spellJSONDir.mkdirs()) {
            return;
        }
        if (!RitualProperties.loadRitualPropertiesFromDir(spellJSONDir)) {
            AncientSpellcraft.logger.warn("Some ritual property files did not load correctly; this will likely cause problems later!");
        }
    }

    private static boolean loadConfigRitualProperties() {
        AncientSpellcraft.logger.info("Loading ritual properties from config folder");
        return true;
    }

    private static boolean loadBuiltInRitualProperties(String modID) {
        ModContainer mod = Loader.instance().getModList().stream().filter(m -> m.getModId().equals(modID)).findFirst().orElse(null);
        if (mod == null) {
            AncientSpellcraft.logger.warn("Tried to load built-in ritual properties for mod with ID '" + modID + "', but no such mod was loaded");
            return false;
        }
        List<Ritual> rituals = Ritual.getRituals(s -> s.getRegistryName().func_110624_b().equals(modID));
        if (modID.equals("ancientspellcraft")) {
            rituals.add(Rituals.none);
        }
        AncientSpellcraft.logger.info("Loading built-in ritual properties for " + rituals.size() + " rituals in mod " + modID);
        boolean success = CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + modID + "/rituals"), null, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(modID, name);
            Ritual ritual = (Ritual)Ritual.registry.getValue(key);
            if (ritual == null) {
                AncientSpellcraft.logger.info("Ritual properties file " + name + ".json does not match any registered rituals; ensure the filename is spelled correctly.");
                return true;
            }
            if (!rituals.remove((Object)ritual)) {
                AncientSpellcraft.logger.warn("What's going on?!");
            }
            if (ritual.arePropertiesInitialised()) {
                return true;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                RitualProperties properties = new RitualProperties(json, ritual);
                ritual.setProperties(properties);
            }
            catch (JsonParseException jsonparseexception) {
                AncientSpellcraft.logger.error("Parsing error loading ritual property file for " + key, (Throwable)jsonparseexception);
                Boolean bl = false;
                return bl;
            }
            catch (IOException ioexception) {
                AncientSpellcraft.logger.error("Couldn't read ritual property file for " + key, (Throwable)ioexception);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)true, (boolean)true);
        if (!rituals.isEmpty()) {
            if (rituals.size() <= 15) {
                rituals.forEach(s -> AncientSpellcraft.logger.error("Ritual " + s.getRegistryName() + " is missing a properties file!"));
            } else {
                AncientSpellcraft.logger.error("Mod " + modID + " has " + rituals.size() + " rituals that are missing properties files!");
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadRitualPropertiesFromDir(File dir) {
        boolean success = true;
        for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"json"}, (boolean)true)) {
            String name;
            String relative = dir.toPath().relativize(file.toPath()).toString();
            String nameAndModID = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            String modID = nameAndModID.split("/")[0];
            ResourceLocation key = new ResourceLocation(modID, name = nameAndModID.substring(nameAndModID.indexOf(47) + 1));
            Ritual ritual = (Ritual)Ritual.registry.getValue(key);
            if (ritual == null) {
                AncientSpellcraft.logger.info("Ritual properties file " + nameAndModID + ".json does not match any registered rituals; ensure the filename is spelled correctly.");
                continue;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file.toPath());
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                RitualProperties properties = new RitualProperties(json, ritual);
                ritual.setProperties(properties);
            }
            catch (JsonParseException jsonparseexception) {
                AncientSpellcraft.logger.error("Parsing error loading ritual property file for " + key, (Throwable)jsonparseexception);
                success = false;
            }
            catch (IOException ioexception) {
                AncientSpellcraft.logger.error("Couldn't read ritual property file for " + key, (Throwable)ioexception);
                success = false;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        return success;
    }

    protected static String[] shrink(String ... strings) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < strings.length; ++i1) {
            String s = strings[i1];
            i = Math.min(i, RitualProperties.firstNonSpace(s));
            int j1 = RitualProperties.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (strings.length == l) {
            return new String[0];
        }
        String[] astring = new String[strings.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = strings[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }
}

