/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.tileentity;

import com.windanesz.ancientspellcraft.block.BlockSageLectern;
import com.windanesz.ancientspellcraft.client.gui.ContainerSageLectern;
import com.windanesz.ancientspellcraft.item.ItemSageTome;
import com.windanesz.ancientspellcraft.item.WizardClassWeaponHelper;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.SpellLecternInteract;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class TileSageLectern
extends TileEntity
implements ITickable,
IInventory {
    public static final double BOOK_OPEN_DISTANCE = 1.0;
    public static final int BOOK_SLOT = 0;
    private static final Random rand = new Random();
    public int ticksExisted;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookSpread;
    public float bookSpreadPrev;
    private NonNullList<ItemStack> inventory;
    private boolean inUse = false;
    private EntityPlayer currentPlayer;
    private List<SpellLecternInteract> spellEffects = new ArrayList<SpellLecternInteract>();

    public TileSageLectern() {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public List<SpellLecternInteract> getSpellEffects() {
        return this.spellEffects;
    }

    private void resetEffects() {
        this.spellEffects.removeIf(effect -> effect instanceof SpellLecternInteract && !effect.persistsOnBookRemoval());
        this.func_70296_d();
    }

    public void removeSpellEffect(SpellLecternInteract spell) {
        this.spellEffects.remove(spell);
        this.func_70296_d();
    }

    public void addSpellEffect(SpellLecternInteract spellEffects) {
        if (!this.spellEffects.contains(spellEffects)) {
            this.spellEffects.add(spellEffects);
            this.func_70296_d();
        }
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public EntityPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(EntityPlayer currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public String func_70005_c_() {
        return "container.ancientspellcraft:sage_lectern";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_73660_a() {
        EntityPlayer player;
        EnumFacing facing;
        this.bookSpreadPrev = this.bookSpread;
        BlockPos pos = new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        EnumFacing enumFacing = facing = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockSageLectern ? (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D) : null;
        if (facing != null) {
            pos = pos.func_177972_a(facing);
        }
        if ((player = this.field_145850_b.func_184137_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0, false)) != null && this.shouldBookOpen(player)) {
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
                float f1 = this.flipT;
                while (f1 == this.flipT) {
                    this.flipT += (float)(rand.nextInt(4) - rand.nextInt(4));
                }
            }
            if (this.field_145850_b.field_72995_K) {
                int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(this.getBookElement());
                Element element = WizardArmourUtils.getFullSetElementForClass((EntityLivingBase)player, ItemWizardArmour.ArmourClass.SAGE);
                if (element != Element.MAGIC && element == this.getBookElement()) {
                    for (int i = 0; i < 2; ++i) {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)((float)this.field_174879_c.func_177958_n() + rand.nextFloat()), (double)(this.field_174879_c.func_177956_o() + 1), (double)((float)this.field_174879_c.func_177952_p() + rand.nextFloat())).vel(0.0, 0.05 + (double)rand.nextFloat() * 0.1, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(this.field_145850_b);
                    }
                }
            }
        } else {
            this.bookSpread -= 0.1f;
        }
        this.bookSpread = MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)1.0f);
        ++this.ticksExisted;
        this.pageFlipPrev = this.pageFlip;
        float f = (this.flipT - this.pageFlip) * 0.4f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    public boolean hasItem() {
        return !this.func_70301_a(0).func_190926_b();
    }

    public ItemStack getBookSlotItem() {
        return this.func_70301_a(0) == null ? ItemStack.field_190927_a : this.func_70301_a(0);
    }

    public Element getBookElement() {
        if (this.getBookSlotItem().func_77973_b() instanceof ItemSageTome) {
            return ((ItemSageTome)this.getBookSlotItem().func_77973_b()).element;
        }
        return Element.MAGIC;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(slot);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (slot == 0 || slot == 1) {
            this.inventory.set(ContainerSageLectern.RESULT_SLOT, (Object)this.getResultItem());
        }
        this.resetEffects();
        this.func_70296_d();
    }

    private ItemStack getResultItem() {
        ItemStack stack0 = (ItemStack)this.inventory.get(ContainerSageLectern.INPUT_SLOT_0);
        ItemStack stack1 = (ItemStack)this.inventory.get(ContainerSageLectern.INPUT_SLOT_1);
        if (stack0.func_77973_b() instanceof ItemSageTome && stack1.func_77973_b() == ASItems.enchanted_page) {
            int progression;
            Tier tier = ((ItemSageTome)stack0.func_77973_b()).tier;
            if (tier.ordinal() >= Tier.MASTER.ordinal() || (progression = WandHelper.getProgression((ItemStack)stack0)) >= tier.next().getProgression()) {
                // empty if block
            }
            throw new IllegalArgumentException("Incomplete feature..");
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getProgressedTome(ItemStack tome) {
        Tier tier = ((ItemSageTome)tome.func_77973_b()).tier;
        Element element = ((ItemSageTome)tome.func_77973_b()).element;
        ItemStack copy = tome.func_77946_l();
        ItemStack progressedTome = new ItemStack(WizardClassWeaponHelper.getClassItemForTier(tier.next(), ItemWizardArmour.ArmourClass.SAGE, element));
        progressedTome.func_77982_d(copy.func_77978_p());
        return progressedTome;
    }

    public int func_70302_i_() {
        return 3;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldBookOpen(EntityPlayer player) {
        if (!this.hasItem()) {
            return true;
        }
        if (this.getBookSlotItem().func_77973_b() instanceof ItemSageTome) {
            return WizardArmourUtils.isWearingFullSet((EntityLivingBase)player, null, ItemWizardArmour.ArmourClass.SAGE);
        }
        return true;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        boolean withinDistance = this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_174831_c(this.field_174879_c) < 64.0;
        return withinDistance && (!this.inUse || player == this.getCurrentPlayer());
    }

    public void func_174889_b(EntityPlayer player) {
        this.setInUse(true);
        this.setCurrentPlayer(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.setInUse(false);
        this.setCurrentPlayer(null);
    }

    public boolean func_94041_b(int slotNumber, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return true;
        }
        if (slotNumber == 0 && stack.func_77973_b() instanceof ItemSageTome) {
            return true;
        }
        if (slotNumber == 1) {
            return stack.func_77973_b() == ASItems.enchanted_page;
        }
        return false;
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public void sync() {
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList inventoryList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            inventoryList.func_74742_a((NBTBase)tag);
        }
        NBTExtras.storeTagSafely((NBTTagCompound)compound, (String)"SpellEffects", (NBTBase)NBTExtras.listToNBT(this.spellEffects, s -> new NBTTagString(s.getRegistryName().toString())));
        NBTExtras.storeTagSafely((NBTTagCompound)compound, (String)"Inventory", (NBTBase)inventoryList);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList inventoryList = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
            NBTTagCompound tag2 = inventoryList.func_150305_b(i);
            byte slot = tag2.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(tag2));
        }
        if (compound.func_74764_b("SpellEffects")) {
            this.spellEffects = (List)NBTExtras.NBTToList((NBTTagList)compound.func_150295_c("SpellEffects", 8), tag -> (SpellLecternInteract)Spell.get((String)tag.func_150285_a_()));
        }
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

