/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WithdrawLife
extends Spell {
    public static final String PERCENT_PER_MINION = "percent_per_minion";

    public WithdrawLife() {
        super("ancientspellcraft", "withdraw_life", SpellActions.POINT_UP, false);
        this.addProperties(new String[]{"effect_radius", PERCENT_PER_MINION});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        float percentPerMinion = this.getProperty(PERCENT_PER_MINION).floatValue();
        int minions = 0;
        for (EntityLivingBase entity : EntityUtils.getEntitiesWithinRadius((double)this.getProperty("effect_radius").floatValue(), (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class)) {
            if (entity == caster || !(entity instanceof ISummonedCreature) || ((ISummonedCreature)entity).getCaster() == null || ((ISummonedCreature)entity).getCaster() != caster) continue;
            ++minions;
            float newHP = entity.func_110143_aJ() - entity.func_110138_aP() * (percentPerMinion * 1.5f);
            if (!world.field_72995_K) {
                if (newHP <= 0.0f) {
                    entity.func_70106_y();
                } else {
                    entity.func_70606_j(newHP);
                }
            }
            if (world.field_72995_K) {
                Vec3d origin = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - 0.25, entity.field_70161_v);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).entity((Entity)entity).time(10).fade(0).clr(189, 0, 19).pos(caster != null ? origin.func_178788_d(entity.func_174791_d()) : origin).target((Entity)caster).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(189, 0, 19).spawn(world);
            }
            if (minions <= 4) continue;
            break;
        }
        if (minions > 0) {
            if (!world.field_72995_K) {
                float heal = caster.func_110138_aP() * percentPerMinion * (float)minions;
                float excess = caster.func_110143_aJ() + heal - caster.func_110138_aP();
                if (excess > 0.0f && ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.ring_withdraw_life)) {
                    int amplifier = Math.max(0, (int)(excess / 3.0f - 1.0f));
                    caster.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 160, amplifier));
                }
                caster.func_70691_i(heal);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

